/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.metadata;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdSelectivity;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.ignite.internal.sql.engine.rel.AbstractIndexScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteHashIndexSpool;
import org.apache.ignite.internal.sql.engine.rel.IgniteSortedIndexSpool;
import org.apache.ignite.internal.sql.engine.rel.ProjectableFilterableTableScan;
import org.apache.ignite.internal.sql.engine.util.RexUtils;
import org.apache.ignite.internal.util.CollectionUtils;

public class IgniteMdSelectivity
extends RelMdSelectivity {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.SELECTIVITY.method, (MetadataHandler)new IgniteMdSelectivity());

    public Double getSelectivity(AbstractIndexScan rel, RelMetadataQuery mq, RexNode predicate) {
        if (predicate != null) {
            return this.getSelectivity((ProjectableFilterableTableScan)rel, mq, predicate);
        }
        List<RexNode> lowerCond = rel.lowerCondition();
        List<RexNode> upperCond = rel.upperCondition();
        if (CollectionUtils.nullOrEmpty(lowerCond) && CollectionUtils.nullOrEmpty(upperCond)) {
            return RelMdUtil.guessSelectivity((RexNode)rel.condition());
        }
        double idxSelectivity = 1.0;
        int len = CollectionUtils.nullOrEmpty(lowerCond) ? upperCond.size() : (CollectionUtils.nullOrEmpty(upperCond) ? lowerCond.size() : Math.max(lowerCond.size(), upperCond.size()));
        for (int i = 0; i < len; ++i) {
            RexCall upper;
            RexCall lower = CollectionUtils.nullOrEmpty(lowerCond) || lowerCond.size() <= i ? null : (RexCall)lowerCond.get(i);
            RexCall rexCall = upper = CollectionUtils.nullOrEmpty(upperCond) || upperCond.size() <= i ? null : (RexCall)upperCond.get(i);
            assert (lower != null || upper != null);
            if (lower != null && upper != null) {
                idxSelectivity *= lower.op.kind == SqlKind.EQUALS ? 0.1 : 0.2;
                continue;
            }
            idxSelectivity *= 0.35;
        }
        List conjunctions = RelOptUtil.conjunctions((RexNode)rel.condition());
        if (!CollectionUtils.nullOrEmpty(lowerCond)) {
            conjunctions.removeAll(lowerCond);
        }
        if (!CollectionUtils.nullOrEmpty(upperCond)) {
            conjunctions.removeAll(upperCond);
        }
        RexNode remaining = RexUtil.composeConjunction((RexBuilder)RexUtils.builder((RelNode)rel), (Iterable)conjunctions, (boolean)true);
        return idxSelectivity * RelMdUtil.guessSelectivity((RexNode)remaining);
    }

    public Double getSelectivity(ProjectableFilterableTableScan rel, RelMetadataQuery mq, RexNode predicate) {
        if (predicate == null) {
            return RelMdUtil.guessSelectivity((RexNode)rel.condition());
        }
        RexNode condition = rel.pushUpPredicate();
        if (condition == null) {
            return RelMdUtil.guessSelectivity((RexNode)predicate);
        }
        RexNode diff = RelMdUtil.minusPreds((RexBuilder)RexUtils.builder((RelNode)rel), (RexNode)predicate, (RexNode)condition);
        return RelMdUtil.guessSelectivity((RexNode)diff);
    }

    public Double getSelectivity(IgniteSortedIndexSpool rel, RelMetadataQuery mq, RexNode predicate) {
        if (predicate != null) {
            return mq.getSelectivity(rel.getInput(), RelMdUtil.minusPreds((RexBuilder)rel.getCluster().getRexBuilder(), (RexNode)predicate, (RexNode)rel.condition()));
        }
        return mq.getSelectivity(rel.getInput(), rel.condition());
    }

    public Double getSelectivity(IgniteHashIndexSpool rel, RelMetadataQuery mq, RexNode predicate) {
        if (predicate != null) {
            return mq.getSelectivity(rel.getInput(), RelMdUtil.minusPreds((RexBuilder)rel.getCluster().getRexBuilder(), (RexNode)predicate, (RexNode)rel.condition()));
        }
        return mq.getSelectivity(rel.getInput(), rel.condition());
    }
}

