/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite.internal.sql.engine.metadata.MappingService;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.TopologyService;
import org.jetbrains.annotations.Nullable;

public class MappingServiceImpl
implements MappingService {
    private final TopologyService topSrvc;

    public MappingServiceImpl(TopologyService topSrvc) {
        this.topSrvc = topSrvc;
    }

    @Override
    public List<String> executionNodes(long topVer, boolean single, @Nullable Predicate<ClusterNode> nodeFilter) {
        List<Object> nodes = new ArrayList(this.topSrvc.allMembers());
        if (nodeFilter != null) {
            nodes = nodes.stream().filter(nodeFilter).collect(Collectors.toList());
        }
        if (single && nodes.size() > 1) {
            nodes = Collections.singletonList((ClusterNode)nodes.get(ThreadLocalRandom.current().nextInt(nodes.size())));
        }
        if (CollectionUtils.nullOrEmpty(nodes)) {
            throw new IllegalStateException("failed to map query to execution nodes. Nodes list is empty.");
        }
        return Commons.transform(nodes, ClusterNode::id);
    }
}

