/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptCostFactory;
import org.apache.calcite.plan.RelOptLattice;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.metadata.CachingRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.RuleSets;
import org.apache.calcite.tools.ValidationException;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.sql.engine.metadata.IgniteMetadata;
import org.apache.ignite.internal.sql.engine.metadata.RelMetadataQueryEx;
import org.apache.ignite.internal.sql.engine.prepare.IgniteSqlValidator;
import org.apache.ignite.internal.sql.engine.prepare.PlannerPhase;
import org.apache.ignite.internal.sql.engine.prepare.PlanningContext;
import org.apache.ignite.internal.sql.engine.prepare.ValidationResult;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.lang.IgniteException;

public class IgnitePlanner
implements Planner,
RelOptTable.ViewExpander {
    private final SqlOperatorTable operatorTbl;
    private final List<Program> programs;
    private final FrameworkConfig frameworkCfg;
    private final PlanningContext ctx;
    private final List<RelTraitDef> traitDefs;
    private final SqlParser.Config parserCfg;
    private final SqlToRelConverter.Config sqlToRelConverterCfg;
    private final SqlValidator.Config validatorCfg;
    private final SqlRexConvertletTable convertletTbl;
    private final RexBuilder rexBuilder;
    private final RexExecutor rexExecutor;
    private final IgniteTypeFactory typeFactory;
    private final CalciteCatalogReader catalogReader;
    private RelOptPlanner planner;
    private SqlValidator validator;
    private RelOptCluster cluster;

    IgnitePlanner(PlanningContext ctx) {
        this.ctx = ctx;
        this.typeFactory = ctx.typeFactory();
        this.catalogReader = ctx.catalogReader();
        this.operatorTbl = ctx.opTable();
        this.frameworkCfg = ctx.config();
        this.programs = this.frameworkCfg.getPrograms();
        this.parserCfg = this.frameworkCfg.getParserConfig();
        this.sqlToRelConverterCfg = this.frameworkCfg.getSqlToRelConverterConfig();
        this.validatorCfg = this.frameworkCfg.getSqlValidatorConfig();
        this.convertletTbl = this.frameworkCfg.getConvertletTable();
        this.rexExecutor = this.frameworkCfg.getExecutor();
        this.traitDefs = this.frameworkCfg.getTraitDefs();
        this.rexBuilder = new RexBuilder((RelDataTypeFactory)this.typeFactory);
    }

    public RelTraitSet getEmptyTraitSet() {
        return this.planner().emptyTraitSet();
    }

    public void close() {
        this.reset();
    }

    public void reset() {
        this.planner = null;
        this.validator = null;
        this.cluster = null;
    }

    public SqlNode parse(Reader reader) throws SqlParseException {
        SqlNodeList sqlNodes = Commons.parse(reader, this.parserCfg);
        return sqlNodes.size() == 1 ? sqlNodes.get(0) : sqlNodes;
    }

    public SqlNode validate(SqlNode sqlNode) throws ValidationException {
        try {
            return this.validator().validate(sqlNode);
        }
        catch (RuntimeException e) {
            throw new ValidationException((Throwable)e);
        }
    }

    public Pair<SqlNode, RelDataType> validateAndGetType(SqlNode sqlNode) {
        SqlNode validatedNode = this.validator().validate(sqlNode);
        RelDataType type = this.validator().getValidatedNodeType(validatedNode);
        return Pair.of((Object)validatedNode, (Object)type);
    }

    public RelDataType convert(SqlDataTypeSpec typeSpec) {
        return typeSpec.deriveType(this.validator());
    }

    public RelNode convert(SqlNode sql) {
        throw new UnsupportedOperationException();
    }

    public ValidationResult validateAndGetTypeMetadata(SqlNode sqlNode) {
        SqlNode validatedNode = this.validator().validate(sqlNode);
        RelDataType type = this.validator().getValidatedNodeType(validatedNode);
        List origins = this.validator().getFieldOrigins(validatedNode);
        return new ValidationResult(validatedNode, type, origins);
    }

    public RelRoot rel(SqlNode sql) {
        SqlToRelConverter sqlToRelConverter = this.sqlToRelConverter(this.validator(), this.catalogReader, this.sqlToRelConverterCfg);
        RelRoot root = sqlToRelConverter.convertQuery(sql, false, true);
        root = root.withRel(sqlToRelConverter.decorrelate(sql, root.rel));
        return root;
    }

    public RelRoot expandView(RelDataType rowType, String qryStr, List<String> schemaPath, List<String> viewPath) {
        SqlNode sqlNode;
        SqlParser parser = SqlParser.create((String)qryStr, (SqlParser.Config)this.parserCfg);
        try {
            sqlNode = parser.parseQuery();
        }
        catch (SqlParseException e) {
            throw new IgniteException("parse failed", (Throwable)e);
        }
        CalciteCatalogReader catalogReader = this.catalogReader.withSchemaPath(schemaPath);
        IgniteSqlValidator validator = new IgniteSqlValidator(this.operatorTbl, catalogReader, this.typeFactory, this.validatorCfg, this.ctx.parameters());
        SqlToRelConverter sqlToRelConverter = this.sqlToRelConverter((SqlValidator)validator, catalogReader, this.sqlToRelConverterCfg);
        RelRoot root = sqlToRelConverter.convertQuery(sqlNode, true, false);
        root = root.withRel(sqlToRelConverter.decorrelate(sqlNode, root.rel));
        return this.trimUnusedFields(root);
    }

    public RelNode transform(int programIdx, RelTraitSet targetTraits, RelNode rel) {
        return this.programs.get(programIdx).run(this.planner(), rel, targetTraits.simplify(), this.materializations(), this.latices());
    }

    public <T extends RelNode> T transform(PlannerPhase phase, RelTraitSet targetTraits, RelNode rel) {
        return (T)phase.getProgram(this.ctx).run(this.planner(), rel, targetTraits.simplify(), this.materializations(), this.latices());
    }

    public IgniteTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    private RelOptPlanner planner() {
        if (this.planner == null) {
            VolcanoPlannerExt planner = new VolcanoPlannerExt(this.frameworkCfg.getCostFactory(), this.ctx);
            planner.setExecutor(this.rexExecutor);
            this.planner = planner;
            for (RelTraitDef def : this.traitDefs) {
                this.planner.addRelTraitDef(def);
            }
        }
        return this.planner;
    }

    public String dump() {
        StringWriter w = new StringWriter();
        ((VolcanoPlanner)this.planner).dump(new PrintWriter(w));
        return w.toString();
    }

    private SqlValidator validator() {
        if (this.validator == null) {
            this.validator = new IgniteSqlValidator(this.operatorTbl, this.catalogReader, this.typeFactory, this.validatorCfg, this.ctx.parameters());
        }
        return this.validator;
    }

    RelOptCluster cluster() {
        if (this.cluster == null) {
            this.cluster = RelOptCluster.create((RelOptPlanner)this.planner(), (RexBuilder)this.rexBuilder);
            this.cluster.setMetadataProvider((RelMetadataProvider)new CachingRelMetadataProvider(IgniteMetadata.METADATA_PROVIDER, this.planner()));
            this.cluster.setMetadataQuerySupplier(RelMetadataQueryEx::create);
        }
        return this.cluster;
    }

    private List<RelOptLattice> latices() {
        return List.of();
    }

    private List<RelOptMaterialization> materializations() {
        return List.of();
    }

    protected RelRoot trimUnusedFields(RelRoot root) {
        SqlToRelConverter.Config config = this.sqlToRelConverterCfg.withExpand(false).withTrimUnusedFields(RelOptUtil.countJoins((RelNode)root.rel) < 2);
        SqlToRelConverter converter = this.sqlToRelConverter(this.validator(), this.catalogReader, config);
        boolean ordered = !root.collation.getFieldCollations().isEmpty();
        boolean dml = SqlKind.DML.contains(root.kind);
        return root.withRel(converter.trimUnusedFields(dml || ordered, root.rel));
    }

    private SqlToRelConverter sqlToRelConverter(SqlValidator validator, CalciteCatalogReader reader, SqlToRelConverter.Config config) {
        return new SqlToRelConverter((RelOptTable.ViewExpander)this, validator, (Prepare.CatalogReader)reader, this.cluster(), this.convertletTbl, config);
    }

    public void setDisabledRules(Set<String> disabledRuleNames) {
        this.ctx.rulesFilter(rulesSet -> {
            ArrayList<RelOptRule> newSet = new ArrayList<RelOptRule>();
            for (RelOptRule r : rulesSet) {
                if (disabledRuleNames.contains(IgnitePlanner.shortRuleName(r.toString()))) continue;
                newSet.add(r);
            }
            return RuleSets.ofList(newSet);
        });
    }

    private static String shortRuleName(String ruleDesc) {
        int pos = ruleDesc.indexOf(40);
        if (pos == -1) {
            return ruleDesc;
        }
        return ruleDesc.substring(0, pos);
    }

    private static class VolcanoPlannerExt
    extends VolcanoPlanner {
        protected VolcanoPlannerExt(RelOptCostFactory costFactory, Context externalCtx) {
            super(costFactory, externalCtx);
            this.setTopDownOpt(true);
        }

        public RelOptCost getCost(RelNode rel, RelMetadataQuery mq) {
            return mq.getCumulativeCost(rel);
        }
    }
}

