/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDelete;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Static;
import org.apache.ignite.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.IgniteResource;
import org.apache.ignite.internal.util.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class IgniteSqlValidator
extends SqlValidatorImpl {
    private static final BigDecimal DEC_INT_MAX = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final int MAX_LENGTH_OF_ALIASES = 256;
    private static final Set<SqlKind> HUMAN_READABLE_ALIASES_FOR;
    Object[] parameters;

    public IgniteSqlValidator(SqlOperatorTable opTab, CalciteCatalogReader catalogReader, IgniteTypeFactory typeFactory, SqlValidator.Config config, Object[] parameters) {
        super(opTab, (SqlValidatorCatalogReader)catalogReader, (RelDataTypeFactory)typeFactory, config);
        this.parameters = parameters;
    }

    public void validateInsert(SqlInsert insert) {
        if (insert.getTargetColumnList() == null) {
            insert.setOperand(3, (SqlNode)this.inferColumnList(insert));
        }
        super.validateInsert(insert);
    }

    public void validateUpdate(SqlUpdate call) {
        this.validateUpdateFields(call);
        super.validateUpdate(call);
    }

    public void validateLiteral(SqlLiteral literal) {
        if (literal.getTypeName() != SqlTypeName.DECIMAL) {
            super.validateLiteral(literal);
        }
    }

    protected SqlSelect createSourceSelectForUpdate(SqlUpdate call) {
        SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
        SqlValidatorTable table = this.getCatalogReader().getTable((List)((SqlIdentifier)call.getTargetTable()).names);
        ((IgniteTable)table.unwrap(IgniteTable.class)).descriptor().selectForUpdateRowType((IgniteTypeFactory)this.typeFactory).getFieldNames().stream().map(name -> new SqlIdentifier(name, SqlParserPos.ZERO)).forEach(arg_0 -> ((SqlNodeList)selectList).add(arg_0));
        int ordinal = 0;
        for (SqlNode exp : call.getSourceExpressionList()) {
            selectList.add(SqlValidatorUtil.addAlias((SqlNode)exp, (String)SqlUtil.deriveAliasFromOrdinal((int)ordinal++)));
        }
        SqlNode sourceTable = call.getTargetTable();
        if (call.getAlias() != null) {
            sourceTable = SqlValidatorUtil.addAlias((SqlNode)sourceTable, (String)call.getAlias().getSimple());
        }
        return new SqlSelect(SqlParserPos.ZERO, null, selectList, sourceTable, call.getCondition(), null, null, null, null, null, null, null);
    }

    protected SqlSelect createSourceSelectForDelete(SqlDelete call) {
        SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
        SqlValidatorTable table = this.getCatalogReader().getTable((List)((SqlIdentifier)call.getTargetTable()).names);
        ((IgniteTable)table.unwrap(IgniteTable.class)).descriptor().deleteRowType((IgniteTypeFactory)this.typeFactory).getFieldNames().stream().map(name -> new SqlIdentifier(name, SqlParserPos.ZERO)).forEach(arg_0 -> ((SqlNodeList)selectList).add(arg_0));
        SqlNode sourceTable = call.getTargetTable();
        if (call.getAlias() != null) {
            sourceTable = SqlValidatorUtil.addAlias((SqlNode)sourceTable, (String)call.getAlias().getSimple());
        }
        return new SqlSelect(SqlParserPos.ZERO, null, selectList, sourceTable, call.getCondition(), null, null, null, null, null, null, null);
    }

    protected void validateSelect(SqlSelect select, RelDataType targetRowType) {
        this.checkIntegerLimit(select.getFetch(), "fetch / limit");
        this.checkIntegerLimit(select.getOffset(), "offset");
        super.validateSelect(select, targetRowType);
    }

    private void checkIntegerLimit(SqlNode n, String nodeName) {
        if (n instanceof SqlLiteral) {
            BigDecimal offFetchLimit = ((SqlLiteral)n).bigDecimalValue();
            if (offFetchLimit.compareTo(DEC_INT_MAX) > 0 || offFetchLimit.compareTo(BigDecimal.ZERO) < 0) {
                throw this.newValidationError(n, IgniteResource.INSTANCE.correctIntegerLimit(nodeName));
            }
        } else if (n instanceof SqlDynamicParam) {
            if (ArrayUtils.nullOrEmpty((Object[])this.parameters)) {
                return;
            }
            int idx = ((SqlDynamicParam)n).getIndex();
            if (idx < this.parameters.length) {
                Object param = this.parameters[idx];
                if (this.parameters[idx] instanceof Integer && (Integer)param < 0) {
                    throw this.newValidationError(n, IgniteResource.INSTANCE.correctIntegerLimit(nodeName));
                }
            }
        }
    }

    public String deriveAlias(SqlNode node, int ordinal) {
        if (node.isA(HUMAN_READABLE_ALIASES_FOR)) {
            String alias = node.toSqlString(c -> c.withDialect(CalciteSqlDialect.DEFAULT).withQuoteAllIdentifiers(false).withAlwaysUseParentheses(false).withClauseStartsLine(false)).getSql();
            return alias.substring(0, Math.min(alias.length(), 256));
        }
        return super.deriveAlias(node, ordinal);
    }

    public void validateAggregateParams(SqlCall aggCall, @Nullable SqlNode filter, @Nullable SqlNodeList distinctList, @Nullable SqlNodeList orderList, SqlValidatorScope scope) {
        this.validateAggregateFunction(aggCall, (SqlAggFunction)aggCall.getOperator());
        super.validateAggregateParams(aggCall, filter, null, orderList, scope);
    }

    private void validateAggregateFunction(SqlCall call, SqlAggFunction aggFunction) {
        if (!SqlKind.AGGREGATE.contains(aggFunction.kind)) {
            throw this.newValidationError((SqlNode)call, IgniteResource.INSTANCE.unsupportedAggregationFunction(aggFunction.getName()));
        }
        switch (aggFunction.kind) {
            case COUNT: 
            case SUM: 
            case AVG: 
            case MIN: 
            case MAX: 
            case ANY_VALUE: {
                return;
            }
        }
        throw this.newValidationError((SqlNode)call, IgniteResource.INSTANCE.unsupportedAggregationFunction(aggFunction.getName()));
    }

    private SqlNodeList inferColumnList(SqlInsert call) {
        SqlValidatorTable table = this.table(this.validatedNamespace((SqlNode)call, this.unknownType));
        if (table == null) {
            return null;
        }
        TableDescriptor desc = (TableDescriptor)table.unwrap(TableDescriptor.class);
        if (desc == null) {
            return null;
        }
        SqlNodeList columnList = new SqlNodeList(SqlParserPos.ZERO);
        for (RelDataTypeField field : desc.insertRowType(this.typeFactory()).getFieldList()) {
            columnList.add((SqlNode)new SqlIdentifier(field.getName(), SqlParserPos.ZERO));
        }
        return columnList;
    }

    private void validateUpdateFields(SqlUpdate call) {
        if (call.getTargetColumnList() == null) {
            return;
        }
        SqlValidatorNamespace ns = this.validatedNamespace((SqlNode)call, this.unknownType);
        SqlValidatorTable table = this.table(ns);
        if (table == null) {
            return;
        }
        TableDescriptor desc = (TableDescriptor)table.unwrap(TableDescriptor.class);
        if (desc == null) {
            return;
        }
        RelDataType baseType = table.getRowType();
        RelOptTable relOptTable = this.relOptTable(ns);
        for (SqlNode node : call.getTargetColumnList()) {
            SqlIdentifier id = (SqlIdentifier)node;
            RelDataTypeField target = SqlValidatorUtil.getTargetField((RelDataType)baseType, (RelDataTypeFactory)this.typeFactory(), (SqlIdentifier)id, (SqlValidatorCatalogReader)this.getCatalogReader(), (RelOptTable)relOptTable);
            if (target == null) {
                throw this.newValidationError((SqlNode)id, Static.RESOURCE.unknownTargetColumn(id.toString()));
            }
            if (desc.isUpdateAllowed(relOptTable, target.getIndex())) continue;
            throw this.newValidationError((SqlNode)id, IgniteResource.INSTANCE.cannotUpdateField(id.toString()));
        }
    }

    private SqlValidatorTable table(SqlValidatorNamespace ns) {
        RelOptTable relOptTable = this.relOptTable(ns);
        if (relOptTable != null) {
            return (SqlValidatorTable)relOptTable.unwrap(SqlValidatorTable.class);
        }
        return ns.getTable();
    }

    private RelOptTable relOptTable(SqlValidatorNamespace ns) {
        return SqlValidatorUtil.getRelOptTable((SqlValidatorNamespace)ns, (Prepare.CatalogReader)((Prepare.CatalogReader)this.getCatalogReader().unwrap(Prepare.CatalogReader.class)), null, null);
    }

    private SqlValidatorNamespace validatedNamespace(SqlNode node, RelDataType targetType) {
        SqlValidatorNamespace ns = this.getNamespace(node);
        this.validateNamespace(ns, targetType);
        return ns;
    }

    private IgniteTypeFactory typeFactory() {
        return (IgniteTypeFactory)this.typeFactory;
    }

    static {
        EnumSet<SqlKind> kinds = EnumSet.noneOf(SqlKind.class);
        kinds.addAll(SqlKind.AGGREGATE);
        kinds.addAll(SqlKind.BINARY_ARITHMETIC);
        kinds.addAll(SqlKind.FUNCTION);
        kinds.add(SqlKind.CEIL);
        kinds.add(SqlKind.FLOOR);
        kinds.add(SqlKind.LITERAL);
        HUMAN_READABLE_ALIASES_FOR = Collections.unmodifiableSet(kinds);
    }
}

