/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.core.Spool;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.sql.engine.prepare.IgnitePlanner;
import org.apache.ignite.internal.sql.engine.prepare.IgniteRelShuttle;
import org.apache.ignite.internal.sql.engine.prepare.PlannerPhase;
import org.apache.ignite.internal.sql.engine.rel.AbstractIndexScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.rel.IgniteIndexScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteProject;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableModify;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableSpool;
import org.apache.ignite.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite.internal.sql.engine.schema.InternalIgniteTable;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.HintUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.lang.IgniteLogger;

public class PlannerHelper {
    private static final IgniteLogger LOG = IgniteLogger.forClass(PlannerHelper.class);

    private PlannerHelper() {
    }

    public static IgniteRel optimize(SqlNode sqlNode, IgnitePlanner planner) {
        try {
            RelRoot root = planner.rel(sqlNode);
            Object rel = root.rel;
            if (HintUtils.containsDisabledRules((List<RelHint>)root.hints)) {
                planner.setDisabledRules(HintUtils.disabledRules((List<RelHint>)root.hints));
            }
            rel = planner.transform(PlannerPhase.HEP_DECORRELATE, rel.getTraitSet(), (RelNode)rel);
            rel = planner.transform(PlannerPhase.HEP_FILTER_PUSH_DOWN, rel.getTraitSet(), (RelNode)rel);
            rel = planner.transform(PlannerPhase.HEP_PROJECT_PUSH_DOWN, rel.getTraitSet(), (RelNode)rel);
            RelTraitSet desired = rel.getCluster().traitSet().replace((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)IgniteDistributions.single()).replace((RelTrait)(root.collation == null ? RelCollations.EMPTY : root.collation)).simplify();
            IgniteRel igniteRel = (IgniteRel)planner.transform(PlannerPhase.OPTIMIZATION, desired, (RelNode)rel);
            if (!root.isRefTrivial()) {
                ArrayList<RexInputRef> projects = new ArrayList<RexInputRef>();
                RexBuilder rexBuilder = igniteRel.getCluster().getRexBuilder();
                Iterator iterator = Pair.left((List)root.fields).iterator();
                while (iterator.hasNext()) {
                    int field = (Integer)iterator.next();
                    projects.add(rexBuilder.makeInputRef((RelNode)igniteRel, field));
                }
                igniteRel = new IgniteProject(igniteRel.getCluster(), desired, (RelNode)igniteRel, projects, root.validatedRowType);
            }
            if (sqlNode.isA(Set.of(SqlKind.INSERT, SqlKind.UPDATE, SqlKind.MERGE))) {
                igniteRel = new FixDependentModifyNodeShuttle().visit(igniteRel);
            }
            return igniteRel;
        }
        catch (Throwable ex) {
            LOG.error("Unexpected error at query optimizer.", ex);
            if (LOG.isDebugEnabled()) {
                LOG.error(planner.dump(), new Object[0]);
            }
            throw ex;
        }
    }

    private static class FixDependentModifyNodeShuttle
    extends IgniteRelShuttle {
        private boolean spoolNeeded;
        private IgniteTableModify modifyNode;

        private FixDependentModifyNodeShuttle() {
        }

        @Override
        public IgniteRel visit(IgniteTableModify rel) {
            assert (this.modifyNode == null);
            this.modifyNode = rel;
            if (rel.isDelete()) {
                return rel;
            }
            this.processNode(rel);
            if (this.spoolNeeded) {
                IgniteTableSpool spool = new IgniteTableSpool(rel.getCluster(), rel.getInput().getTraitSet(), Spool.Type.EAGER, rel.getInput());
                rel.replaceInput(0, (RelNode)spool);
            }
            return rel;
        }

        @Override
        public IgniteRel visit(IgniteTableScan rel) {
            return this.processScan(rel);
        }

        @Override
        public IgniteRel visit(IgniteIndexScan rel) {
            return this.processScan(rel);
        }

        @Override
        protected IgniteRel processNode(IgniteRel rel) {
            List inputs = Commons.cast(rel.getInputs());
            for (int i = 0; i < inputs.size() && !this.spoolNeeded; ++i) {
                this.visitChild(rel, i, (IgniteRel)inputs.get(i));
            }
            return rel;
        }

        private IgniteRel processScan(TableScan scan) {
            InternalIgniteTable tbl;
            InternalIgniteTable internalIgniteTable = tbl = this.modifyNode != null ? (InternalIgniteTable)this.modifyNode.getTable().unwrap(InternalIgniteTable.class) : null;
            if (tbl == null || scan.getTable().unwrap(InternalIgniteTable.class) != tbl) {
                return (IgniteRel)scan;
            }
            if (this.modifyNodeInsertsData()) {
                this.spoolNeeded = true;
                return (IgniteRel)scan;
            }
            if (scan instanceof IgniteTableScan) {
                return (IgniteRel)scan;
            }
            IntSet indexedCols = CollectionUtils.setOf((Collection)tbl.getIndex(((AbstractIndexScan)scan).indexName()).collation().getKeys());
            this.spoolNeeded = this.modifyNode.getUpdateColumnList().stream().map(tbl.descriptor()::columnDescriptor).mapToInt(ColumnDescriptor::fieldIndex).anyMatch(arg_0 -> ((IntSet)indexedCols).contains(arg_0));
            return (IgniteRel)scan;
        }

        private boolean modifyNodeInsertsData() {
            return this.modifyNode.isInsert();
        }
    }
}

