/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare;

import java.util.List;
import java.util.function.Function;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.RuleSet;
import org.apache.ignite.internal.sql.engine.extension.SqlExtension;
import org.apache.ignite.internal.sql.engine.prepare.IgnitePlanner;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.BaseQueryContext;
import org.jetbrains.annotations.NotNull;

public final class PlanningContext
implements Context {
    private final Context parentCtx;
    private final String qry;
    private final Object[] parameters;
    private Function<RuleSet, RuleSet> rulesFilter;
    private IgnitePlanner planner;

    private PlanningContext(Context parentCtx, String qry, Object[] parameters) {
        this.qry = qry;
        this.parameters = parameters;
        this.parentCtx = parentCtx;
    }

    public FrameworkConfig config() {
        return this.unwrap(BaseQueryContext.class).config();
    }

    public List<SqlExtension> extensions() {
        return this.unwrap(BaseQueryContext.class).extensions();
    }

    public String query() {
        return this.qry;
    }

    public Object[] parameters() {
        return this.parameters;
    }

    public SqlOperatorTable opTable() {
        return this.config().getOperatorTable();
    }

    public SqlConformance conformance() {
        return this.config().getParserConfig().conformance();
    }

    public IgnitePlanner planner() {
        if (this.planner == null) {
            this.planner = new IgnitePlanner(this);
        }
        return this.planner;
    }

    public String schemaName() {
        return this.schema().getName();
    }

    public SchemaPlus schema() {
        return this.config().getDefaultSchema();
    }

    public IgniteTypeFactory typeFactory() {
        return this.unwrap(BaseQueryContext.class).typeFactory();
    }

    public CalciteCatalogReader catalogReader() {
        return this.unwrap(BaseQueryContext.class).catalogReader();
    }

    public RelOptCluster cluster() {
        return this.planner().cluster();
    }

    public <C> C unwrap(Class<C> clazz) {
        if (clazz == this.getClass()) {
            return clazz.cast(this);
        }
        return (C)this.parentCtx.unwrap(clazz);
    }

    public static Builder builder() {
        return new Builder();
    }

    public RuleSet rules(RuleSet set) {
        return this.rulesFilter != null ? this.rulesFilter.apply(set) : set;
    }

    public void rulesFilter(Function<RuleSet, RuleSet> rulesFilter) {
        this.rulesFilter = rulesFilter;
    }

    public static class Builder {
        private Context parentCtx = Contexts.empty();
        private String qry;
        private Object[] parameters;

        public Builder parentContext(@NotNull Context parentCtx) {
            this.parentCtx = parentCtx;
            return this;
        }

        public Builder query(@NotNull String qry) {
            this.qry = qry;
            return this;
        }

        public Builder parameters(Object ... parameters) {
            this.parameters = parameters;
            return this;
        }

        public PlanningContext build() {
            return new PlanningContext(this.parentCtx, this.qry, this.parameters);
        }
    }
}

