/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.apache.ignite.internal.sql.engine.prepare.CacheKey;
import org.apache.ignite.internal.sql.engine.prepare.QueryPlan;
import org.apache.ignite.internal.sql.engine.prepare.QueryPlanCache;

public class QueryPlanCacheImpl
implements QueryPlanCache {
    private final ConcurrentMap<CacheKey, QueryPlan> cache;

    public QueryPlanCacheImpl(int cacheSize) {
        this.cache = Caffeine.newBuilder().maximumSize((long)cacheSize).build().asMap();
    }

    @Override
    public QueryPlan queryPlan(CacheKey key, Supplier<QueryPlan> planSupplier) {
        ConcurrentMap<CacheKey, QueryPlan> cache = this.cache;
        QueryPlan plan = cache.computeIfAbsent(key, k -> (QueryPlan)planSupplier.get());
        return plan.copy();
    }

    @Override
    public QueryPlan queryPlan(CacheKey key) {
        ConcurrentMap<CacheKey, QueryPlan> cache = this.cache;
        QueryPlan plan = (QueryPlan)cache.get(key);
        return plan != null ? plan.copy() : null;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.clear();
    }
}

