/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare;

import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.ignite.internal.sql.engine.metadata.FragmentMappingException;
import org.apache.ignite.internal.sql.engine.metadata.MappingService;
import org.apache.ignite.internal.sql.engine.prepare.ExecutionPlan;
import org.apache.ignite.internal.sql.engine.prepare.Fragment;
import org.apache.ignite.internal.sql.engine.prepare.FragmentSplitter;
import org.apache.ignite.internal.sql.engine.prepare.MappingQueryContext;
import org.apache.ignite.internal.sql.engine.rel.IgniteReceiver;
import org.apache.ignite.internal.sql.engine.rel.IgniteSender;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.lang.IgniteException;
import org.jetbrains.annotations.NotNull;

public class QueryTemplate {
    private final List<Fragment> fragments;
    private final AtomicReference<ExecutionPlan> executionPlan = new AtomicReference();

    public QueryTemplate(List<Fragment> fragments) {
        ArrayList<Fragment> frgs = new ArrayList<Fragment>(fragments.size());
        RelOptCluster cluster = Commons.createCluster();
        for (Fragment fragment : fragments) {
            frgs.add(fragment.copy(cluster));
        }
        this.fragments = List.copyOf(frgs);
    }

    public ExecutionPlan map(MappingService mappingService, MappingQueryContext ctx) {
        ExecutionPlan executionPlan = this.executionPlan.get();
        if (executionPlan != null && Objects.equals(executionPlan.topologyVersion(), ctx.topologyVersion())) {
            return executionPlan;
        }
        RelOptCluster cluster = Commons.createCluster();
        List<Fragment> fragments = Commons.transform(this.fragments, fragment -> fragment.copy(cluster));
        FragmentMappingException ex = null;
        RelMetadataQuery mq = ((Fragment)CollectionUtils.first(fragments)).root().getCluster().getMetadataQuery();
        for (int i = 0; i < 3; ++i) {
            try {
                ExecutionPlan executionPlan0 = new ExecutionPlan(ctx.topologyVersion(), this.map(mappingService, fragments, ctx, mq));
                if (executionPlan == null || executionPlan.topologyVersion() < executionPlan0.topologyVersion()) {
                    this.executionPlan.compareAndSet(executionPlan, executionPlan0);
                }
                return executionPlan0;
            }
            catch (FragmentMappingException e) {
                if (ex == null) {
                    ex = e;
                } else {
                    ex.addSuppressed(e);
                }
                fragments = this.replace(fragments, e.fragment(), new FragmentSplitter(e.node()).go(e.fragment()));
                continue;
            }
        }
        throw new IgniteException("Failed to map query.", ex);
    }

    @NotNull
    private List<Fragment> map(MappingService mappingService, List<Fragment> fragments, MappingQueryContext ctx, RelMetadataQuery mq) {
        ArrayList<Fragment> frgs = new ArrayList<Fragment>();
        for (Fragment fragment : fragments) {
            frgs.add(fragment.map(mappingService, ctx, mq));
        }
        return List.copyOf(frgs);
    }

    private List<Fragment> replace(List<Fragment> fragments, Fragment fragment, List<Fragment> replacement) {
        assert (!CollectionUtils.nullOrEmpty(replacement));
        Long2LongOpenHashMap newTargets = new Long2LongOpenHashMap();
        for (Fragment fragment0 : replacement) {
            for (IgniteReceiver remote : fragment0.remotes()) {
                newTargets.put(remote.exchangeId(), fragment0.fragmentId());
            }
        }
        ArrayList<Fragment> fragments0 = new ArrayList<Fragment>(fragments.size() + replacement.size() - 1);
        for (Fragment fragment0 : fragments) {
            IgniteSender sender;
            long newTargetId;
            if (fragment0 == fragment) {
                fragment0 = (Fragment)CollectionUtils.first(replacement);
            } else if (!fragment0.rootFragment() && (newTargetId = newTargets.getOrDefault((sender = (IgniteSender)fragment0.root()).exchangeId(), Long.MIN_VALUE)) != Long.MIN_VALUE) {
                sender = new IgniteSender(sender.getCluster(), sender.getTraitSet(), sender.getInput(), sender.exchangeId(), newTargetId, sender.distribution());
                fragment0 = new Fragment(fragment0.fragmentId(), sender, fragment0.remotes());
            }
            fragments0.add(fragment0);
        }
        fragments0.addAll(replacement.subList(1, replacement.size()));
        return fragments0;
    }
}

