/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.ignite.internal.sql.engine.ResultFieldMetadata;
import org.apache.ignite.internal.sql.engine.prepare.ResultFieldMetadataImpl;
import org.apache.ignite.internal.sql.engine.prepare.ResultSetMetadataInternal;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;

public class ResultSetMetadataImpl
implements ResultSetMetadataInternal {
    private final List<List<String>> origins;
    private final RelDataType rowType;
    private volatile List<ResultFieldMetadata> fields;

    public ResultSetMetadataImpl(RelDataType rowType, List<List<String>> origins) {
        this.rowType = rowType;
        this.origins = origins;
    }

    @Override
    public List<ResultFieldMetadata> fields() {
        if (this.fields == null) {
            ArrayList<ResultFieldMetadata> flds = new ArrayList<ResultFieldMetadata>(this.rowType.getFieldCount());
            for (int i = 0; i < this.rowType.getFieldCount(); ++i) {
                RelDataTypeField fld = (RelDataTypeField)this.rowType.getFieldList().get(i);
                flds.add(new ResultFieldMetadataImpl(fld.getName(), TypeUtils.nativeType(fld.getType()), fld.getIndex(), fld.getType().isNullable(), this.origins.get(i)));
                this.fields = flds;
            }
        }
        return this.fields;
    }

    @Override
    public RelDataType rowType() {
        return this.rowType;
    }
}

