/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare.ddl;

import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.jetbrains.annotations.Nullable;

public class ColumnDefinition {
    private final String name;
    private final RelDataType type;
    private final Object dflt;

    public ColumnDefinition(String name, RelDataType type, @Nullable Object dflt) {
        this.name = Objects.requireNonNull(name, "name");
        this.type = Objects.requireNonNull(type, "type");
        this.dflt = dflt;
    }

    public String name() {
        return this.name;
    }

    public RelDataType type() {
        return this.type;
    }

    @Nullable
    public Object defaultValue() {
        return this.dflt;
    }

    public boolean nullable() {
        return this.type.isNullable();
    }

    public Integer precision() {
        return this.type.getPrecision() != -1 ? Integer.valueOf(this.type.getPrecision()) : null;
    }

    public Integer scale() {
        return this.type.getScale() != Integer.MIN_VALUE ? Integer.valueOf(this.type.getScale()) : null;
    }
}

