/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare.ddl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDdl;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.ddl.SqlColumnDeclaration;
import org.apache.calcite.sql.ddl.SqlDropTable;
import org.apache.calcite.sql.ddl.SqlKeyConstraint;
import org.apache.ignite.internal.sql.engine.prepare.IgnitePlanner;
import org.apache.ignite.internal.sql.engine.prepare.PlanningContext;
import org.apache.ignite.internal.sql.engine.prepare.ddl.AlterTableAddCommand;
import org.apache.ignite.internal.sql.engine.prepare.ddl.AlterTableDropCommand;
import org.apache.ignite.internal.sql.engine.prepare.ddl.ColumnDefinition;
import org.apache.ignite.internal.sql.engine.prepare.ddl.CreateIndexCommand;
import org.apache.ignite.internal.sql.engine.prepare.ddl.CreateTableCommand;
import org.apache.ignite.internal.sql.engine.prepare.ddl.DdlCommand;
import org.apache.ignite.internal.sql.engine.prepare.ddl.DropIndexCommand;
import org.apache.ignite.internal.sql.engine.prepare.ddl.DropTableCommand;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlAlterTableAddColumn;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlAlterTableDropColumn;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlCreateIndex;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlCreateTable;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlCreateTableOption;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlCreateTableOptionEnum;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlDropIndex;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.Pair;
import org.apache.ignite.lang.IgniteException;

public class DdlSqlToCommandConverter {
    private static final TableOptionProcessor<Void> UNSUPPORTED_OPTION_PROCESSOR = new TableOptionProcessor<Void>(null, (opt, ctx) -> {
        throw new AssertionError((Object)("Unsupported option " + opt.key()));
    }, null);
    private BiFunction<IgniteSqlCreateTableOption, PlanningContext, Integer> positiveNumValidator = (opt, ctx) -> {
        if (!(opt.value() instanceof SqlNumericLiteral) || !((SqlNumericLiteral)opt.value()).isInteger() || ((SqlLiteral)opt.value()).intValue(true) < 0) {
            DdlSqlToCommandConverter.throwOptionParsingException(opt, "a non-negative integer", ctx.query());
        }
        return ((SqlLiteral)opt.value()).intValue(true);
    };
    private final Map<IgniteSqlCreateTableOptionEnum, TableOptionProcessor<?>> tblOptionProcessors = Stream.of(new TableOptionProcessor<Integer>(IgniteSqlCreateTableOptionEnum.REPLICAS, this.positiveNumValidator, CreateTableCommand::replicas), new TableOptionProcessor<Integer>(IgniteSqlCreateTableOptionEnum.PARTITIONS, this.positiveNumValidator, CreateTableCommand::partitions)).collect(Collectors.toMap(rec$ -> ((TableOptionProcessor)rec$).key(), Function.identity()));

    public DdlCommand convert(SqlDdl ddlNode, PlanningContext ctx) {
        if (ddlNode instanceof IgniteSqlCreateTable) {
            return this.convertCreateTable((IgniteSqlCreateTable)ddlNode, ctx);
        }
        if (ddlNode instanceof SqlDropTable) {
            return this.convertDropTable((SqlDropTable)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlAlterTableAddColumn) {
            return this.convertAlterTableAdd((IgniteSqlAlterTableAddColumn)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlAlterTableDropColumn) {
            return this.convertAlterTableDrop((IgniteSqlAlterTableDropColumn)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlCreateIndex) {
            return this.convertAddIndex((IgniteSqlCreateIndex)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlDropIndex) {
            return this.convertDropIndex((IgniteSqlDropIndex)ddlNode);
        }
        throw new IgniteException("Unsupported operation [sqlNodeKind=" + ddlNode.getKind() + "; querySql=\"" + ctx.query() + "\"]");
    }

    private CreateTableCommand convertCreateTable(IgniteSqlCreateTable createTblNode, PlanningContext ctx) {
        CreateTableCommand createTblCmd = new CreateTableCommand();
        createTblCmd.schemaName(this.deriveSchemaName(createTblNode.name(), ctx));
        createTblCmd.tableName(this.deriveObjectName(createTblNode.name(), ctx, "tableName"));
        createTblCmd.ifTableExists(createTblNode.ifNotExists());
        if (createTblNode.createOptionList() != null) {
            for (SqlNode optNode : createTblNode.createOptionList().getList()) {
                IgniteSqlCreateTableOption opt = (IgniteSqlCreateTableOption)optNode;
                this.tblOptionProcessors.getOrDefault((Object)opt.key(), UNSUPPORTED_OPTION_PROCESSOR).process(opt, ctx, createTblCmd);
            }
        }
        List colDeclarations = createTblNode.columnList().getList().stream().filter(SqlColumnDeclaration.class::isInstance).map(SqlColumnDeclaration.class::cast).collect(Collectors.toList());
        IgnitePlanner planner = ctx.planner();
        ArrayList<ColumnDefinition> cols = new ArrayList<ColumnDefinition>(colDeclarations.size());
        for (SqlColumnDeclaration col : colDeclarations) {
            if (!col.name.isSimple()) {
                throw new IgniteException("Unexpected value of columnName [expected a simple identifier, but was " + col.name + "; querySql=\"" + ctx.query() + "\"]");
            }
            String name = col.name.getSimple();
            RelDataType relType = planner.convert(col.dataType);
            Object dflt = null;
            if (col.expression != null) {
                dflt = ((SqlLiteral)col.expression).getValue();
            }
            cols.add(new ColumnDefinition(name, relType, dflt));
        }
        createTblCmd.columns(cols);
        List pkConstraints = createTblNode.columnList().getList().stream().filter(SqlKeyConstraint.class::isInstance).map(SqlKeyConstraint.class::cast).collect(Collectors.toList());
        if (pkConstraints.size() > 1) {
            throw new IgniteException("Unexpected amount of primary key constraints [expected at most one, but was " + pkConstraints.size() + "; querySql=\"" + ctx.query() + "\"]");
        }
        if (!CollectionUtils.nullOrEmpty(pkConstraints)) {
            HashSet dedupSet = new HashSet();
            List<String> pkCols = pkConstraints.stream().map(pk -> (SqlNode)pk.getOperandList().get(1)).map(SqlNodeList.class::cast).flatMap(l -> l.getList().stream()).map(SqlIdentifier.class::cast).map(SqlIdentifier::getSimple).filter(dedupSet::add).collect(Collectors.toList());
            createTblCmd.primaryKeyColumns(pkCols);
        }
        return createTblCmd;
    }

    private AlterTableAddCommand convertAlterTableAdd(IgniteSqlAlterTableAddColumn alterTblNode, PlanningContext ctx) {
        AlterTableAddCommand alterTblCmd = new AlterTableAddCommand();
        alterTblCmd.schemaName(this.deriveSchemaName(alterTblNode.name(), ctx));
        alterTblCmd.tableName(this.deriveObjectName(alterTblNode.name(), ctx, "table name"));
        alterTblCmd.ifTableExists(alterTblNode.ifExists());
        alterTblCmd.ifColumnNotExists(alterTblNode.ifNotExistsColumn());
        ArrayList<ColumnDefinition> cols = new ArrayList<ColumnDefinition>(alterTblNode.columns().size());
        for (SqlNode colNode : alterTblNode.columns()) {
            assert (colNode instanceof SqlColumnDeclaration) : colNode.getClass();
            SqlColumnDeclaration col = (SqlColumnDeclaration)colNode;
            assert (col.name.isSimple());
            Object dflt = null;
            if (col.expression != null) {
                dflt = ((SqlLiteral)col.expression).getValue();
            }
            String name = col.name.getSimple();
            RelDataType relType = ctx.planner().convert(col.dataType);
            cols.add(new ColumnDefinition(name, relType, dflt));
        }
        alterTblCmd.columns(cols);
        return alterTblCmd;
    }

    private AlterTableDropCommand convertAlterTableDrop(IgniteSqlAlterTableDropColumn alterTblNode, PlanningContext ctx) {
        AlterTableDropCommand alterTblCmd = new AlterTableDropCommand();
        alterTblCmd.schemaName(this.deriveSchemaName(alterTblNode.name(), ctx));
        alterTblCmd.tableName(this.deriveObjectName(alterTblNode.name(), ctx, "table name"));
        alterTblCmd.ifTableExists(alterTblNode.ifExists());
        alterTblCmd.ifColumnExists(alterTblNode.ifExistsColumn());
        HashSet<String> cols = new HashSet<String>(alterTblNode.columns().size());
        alterTblNode.columns().forEach(c -> cols.add(((SqlIdentifier)c).getSimple()));
        alterTblCmd.columns(cols);
        return alterTblCmd;
    }

    private DropTableCommand convertDropTable(SqlDropTable dropTblNode, PlanningContext ctx) {
        DropTableCommand dropTblCmd = new DropTableCommand();
        dropTblCmd.schemaName(this.deriveSchemaName(dropTblNode.name, ctx));
        dropTblCmd.tableName(this.deriveObjectName(dropTblNode.name, ctx, "tableName"));
        dropTblCmd.ifTableExists(dropTblNode.ifExists);
        return dropTblCmd;
    }

    private CreateIndexCommand convertAddIndex(IgniteSqlCreateIndex sqlCmd, PlanningContext ctx) {
        CreateIndexCommand createIdxCmd = new CreateIndexCommand();
        createIdxCmd.schemaName(this.deriveSchemaName(sqlCmd.tableName(), ctx));
        createIdxCmd.tableName(this.deriveObjectName(sqlCmd.tableName(), ctx, "table name"));
        createIdxCmd.indexName(sqlCmd.indexName().getSimple());
        ArrayList<Pair<String, Boolean>> cols = new ArrayList<Pair<String, Boolean>>(sqlCmd.columnList().size());
        for (SqlNode col : sqlCmd.columnList().getList()) {
            boolean desc = false;
            if (col.getKind() == SqlKind.DESCENDING) {
                col = (SqlNode)((SqlCall)col).getOperandList().get(0);
                desc = true;
            }
            cols.add((Pair<String, Boolean>)new Pair((Object)((SqlIdentifier)col).getSimple(), (Object)desc));
        }
        createIdxCmd.columns(cols);
        createIdxCmd.ifIndexNotExists(sqlCmd.ifNotExists());
        return createIdxCmd;
    }

    private DropIndexCommand convertDropIndex(IgniteSqlDropIndex sqlCmd) {
        DropIndexCommand dropCmd = new DropIndexCommand();
        dropCmd.indexName(sqlCmd.idxName().getSimple());
        dropCmd.ifExist(sqlCmd.ifExists());
        return dropCmd;
    }

    private String deriveSchemaName(SqlIdentifier id, PlanningContext ctx) {
        String schemaName;
        if (id.isSimple()) {
            schemaName = ctx.schemaName();
        } else {
            SqlIdentifier schemaId = id.skipLast(1);
            if (!schemaId.isSimple()) {
                throw new IgniteException("Unexpected value of schemaName [expected a simple identifier, but was " + schemaId + "; querySql=\"" + ctx.query() + "\"]");
            }
            schemaName = schemaId.getSimple();
        }
        this.ensureSchemaExists(ctx, schemaName);
        return schemaName;
    }

    private String deriveObjectName(SqlIdentifier id, PlanningContext ctx, String objDesc) {
        if (id.isSimple()) {
            return id.getSimple();
        }
        SqlIdentifier objId = id.getComponent(id.skipLast((int)1).names.size());
        if (!objId.isSimple()) {
            throw new IgniteException("Unexpected value of " + objDesc + " [expected a simple identifier, but was " + objId + "; querySql=\"" + ctx.query() + "\"]");
        }
        return objId.getSimple();
    }

    private void ensureSchemaExists(PlanningContext ctx, String schemaName) {
        if (ctx.catalogReader().getRootSchema().getSubSchema(schemaName, true) == null) {
            throw new IgniteException("Schema with name " + schemaName + " not found");
        }
    }

    private String paramIsSqlIdentifierValidator(IgniteSqlCreateTableOption opt, PlanningContext ctx) {
        if (!(opt.value() instanceof SqlIdentifier) || !((SqlIdentifier)opt.value()).isSimple()) {
            DdlSqlToCommandConverter.throwOptionParsingException(opt, "a simple identifier", ctx.query());
        }
        return ((SqlIdentifier)opt.value()).getSimple();
    }

    private static <T extends Enum<T>> BiFunction<IgniteSqlCreateTableOption, PlanningContext, T> validatorForEnumValue(Class<T> clz) {
        return (opt, ctx) -> {
            Enum val = null;
            if (opt.value() instanceof SqlIdentifier) {
                val = Arrays.stream((Enum[])clz.getEnumConstants()).filter(m -> m.name().equalsIgnoreCase(opt.value().toString())).findFirst().orElse(null);
            }
            if (val == null) {
                DdlSqlToCommandConverter.throwOptionParsingException(opt, "values are " + Arrays.toString(clz.getEnumConstants()), ctx.query());
            }
            return val;
        };
    }

    private static void throwOptionParsingException(IgniteSqlCreateTableOption opt, String exp, String qry) {
        throw new IgniteException("Unexpected value for param " + opt.key() + " [expected " + exp + ", but was " + opt.value() + "; querySql=\"" + qry + "\"]");
    }

    private static class TableOptionProcessor<T> {
        private final IgniteSqlCreateTableOptionEnum key;
        private final BiFunction<IgniteSqlCreateTableOption, PlanningContext, T> validator;
        private final BiConsumer<CreateTableCommand, T> valSetter;

        private TableOptionProcessor(IgniteSqlCreateTableOptionEnum key, BiFunction<IgniteSqlCreateTableOption, PlanningContext, T> validator, BiConsumer<CreateTableCommand, T> valSetter) {
            this.key = key;
            this.validator = validator;
            this.valSetter = valSetter;
        }

        private void process(IgniteSqlCreateTableOption opt, PlanningContext ctx, CreateTableCommand cmd) {
            assert (this.key == null || this.key == opt.key()) : "Unexpected create table option [expected=" + this.key + ", actual=" + opt.key() + "]";
            this.valSetter.accept(cmd, (CreateTableCommand)this.validator.apply(opt, ctx));
        }

        private IgniteSqlCreateTableOptionEnum key() {
            return this.key;
        }
    }
}

