/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.sql.engine.rel.AbstractIndexScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite.internal.sql.engine.rel.SourceAwareIgniteRel;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.sql.engine.util.IndexConditions;
import org.jetbrains.annotations.Nullable;

public class IgniteIndexScan
extends AbstractIndexScan
implements SourceAwareIgniteRel {
    private final long sourceId;

    public IgniteIndexScan(RelInput input) {
        super(TraitUtils.changeTraits(input, new RelTrait[]{IgniteConvention.INSTANCE}));
        Object srcIdObj = input.get("sourceId");
        this.sourceId = srcIdObj != null ? ((Number)srcIdObj).longValue() : -1L;
    }

    public IgniteIndexScan(RelOptCluster cluster, RelTraitSet traits, RelOptTable tbl, String idxName) {
        this(cluster, traits, tbl, idxName, null, null, null, null);
    }

    public IgniteIndexScan(RelOptCluster cluster, RelTraitSet traits, RelOptTable tbl, String idxName, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable IndexConditions idxCond, @Nullable ImmutableBitSet requiredCols) {
        this(-1L, cluster, traits, tbl, idxName, proj, cond, idxCond, requiredCols);
    }

    private IgniteIndexScan(long sourceId, RelOptCluster cluster, RelTraitSet traits, RelOptTable tbl, String idxName, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable IndexConditions idxCond, @Nullable ImmutableBitSet requiredCols) {
        super(cluster, traits, List.of(), tbl, idxName, proj, cond, idxCond, requiredCols);
        this.sourceId = sourceId;
    }

    @Override
    public long sourceId() {
        return this.sourceId;
    }

    @Override
    protected RelWriter explainTerms0(RelWriter pw) {
        return super.explainTerms0(pw).itemIf("sourceId", (Object)this.sourceId, this.sourceId != -1L);
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public IgniteRel clone(long sourceId) {
        return new IgniteIndexScan(sourceId, this.getCluster(), this.getTraitSet(), this.getTable(), this.idxName, (List<RexNode>)this.projects, this.condition, this.idxCond, this.requiredColumns);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteIndexScan(this.sourceId, cluster, this.getTraitSet(), this.getTable(), this.idxName, (List<RexNode>)this.projects, this.condition, this.idxCond, this.requiredColumns);
    }
}

