/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel.agg;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.sql.engine.trait.TraitsAwareIgniteRel;
import org.apache.ignite.internal.sql.engine.util.Commons;

interface IgniteSortAggregateBase
extends TraitsAwareIgniteRel {
    public ImmutableBitSet getGroupSet();

    @Override
    default public Pair<RelTraitSet, List<RelTraitSet>> passThroughCollation(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelCollation collation = RelCollations.of((ImmutableIntList)ImmutableIntList.copyOf((Iterable)this.getGroupSet().asList()));
        return Pair.of((Object)nodeTraits.replace((RelTrait)collation), List.of(inputTraits.get(0).replace((RelTrait)collation)));
    }

    @Override
    default public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCollation(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelCollation inputCollation = TraitUtils.collation(inputTraits.get(0));
        IntList newCollation = Commons.maxPrefix(inputCollation.getKeys(), this.getGroupSet().asSet());
        if (newCollation.size() < this.getGroupSet().cardinality()) {
            return List.of();
        }
        return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)RelCollations.of((ImmutableIntList)ImmutableIntList.copyOf((Iterable)newCollation))), inputTraits));
    }
}

