/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel.logical;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite.internal.sql.engine.rel.AbstractIndexScan;
import org.apache.ignite.internal.sql.engine.schema.InternalIgniteTable;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.IndexConditions;
import org.apache.ignite.internal.sql.engine.util.RexUtils;
import org.jetbrains.annotations.Nullable;

public class IgniteLogicalIndexScan
extends AbstractIndexScan {
    public static IgniteLogicalIndexScan create(RelOptCluster cluster, RelTraitSet traits, RelOptTable table, String idxName, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable ImmutableBitSet requiredColumns) {
        InternalIgniteTable tbl = (InternalIgniteTable)table.unwrap(InternalIgniteTable.class);
        IgniteTypeFactory typeFactory = Commons.typeFactory(cluster);
        RelDataType rowType = tbl.getRowType((RelDataTypeFactory)typeFactory, requiredColumns);
        RelCollation collation = tbl.getIndex(idxName).collation();
        if (requiredColumns != null) {
            Mappings.TargetMapping targetMapping = Commons.mapping(requiredColumns, tbl.getRowType((RelDataTypeFactory)typeFactory).getFieldCount());
            collation = (RelCollation)collation.apply(targetMapping);
            if (proj != null) {
                collation = TraitUtils.projectCollation(collation, proj, rowType);
            }
        }
        IndexConditions idxCond = new IndexConditions();
        if (collation != null && !collation.getFieldCollations().isEmpty()) {
            idxCond = RexUtils.buildSortedIndexConditions(cluster, collation, cond, tbl.getRowType((RelDataTypeFactory)typeFactory), requiredColumns);
        }
        return new IgniteLogicalIndexScan(cluster, traits, table, idxName, proj, cond, idxCond, requiredColumns);
    }

    private IgniteLogicalIndexScan(RelOptCluster cluster, RelTraitSet traits, RelOptTable tbl, String idxName, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable IndexConditions idxCond, @Nullable ImmutableBitSet requiredCols) {
        super(cluster, traits, List.of(), tbl, idxName, proj, cond, idxCond, requiredCols);
    }
}

