/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rule;

import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.PhysicalNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.rel.IgniteFilter;
import org.apache.ignite.internal.sql.engine.rule.AbstractIgniteConverterRule;
import org.apache.ignite.internal.sql.engine.trait.CorrelationTrait;
import org.apache.ignite.internal.sql.engine.util.RexUtils;

public class FilterConverterRule
extends AbstractIgniteConverterRule<LogicalFilter> {
    public static final RelOptRule INSTANCE = new FilterConverterRule();

    public FilterConverterRule() {
        super(LogicalFilter.class, "FilterConverterRule");
    }

    @Override
    protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, LogicalFilter rel) {
        RelOptCluster cluster = rel.getCluster();
        RelTraitSet traits = rel.getTraitSet().replace((RelTrait)IgniteConvention.INSTANCE);
        Set<CorrelationId> corrIds = RexUtils.extractCorrelationIds(rel.getCondition());
        if (!corrIds.isEmpty()) {
            traits = traits.replace((RelTrait)CorrelationTrait.correlations(corrIds));
        }
        return new IgniteFilter(cluster, traits, rel.getInput(), rel.getCondition());
    }
}

