/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rule;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Spool;
import org.apache.ignite.internal.sql.engine.rel.IgniteFilter;
import org.apache.ignite.internal.sql.engine.rel.IgniteSortedIndexSpool;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableSpool;
import org.apache.ignite.internal.sql.engine.trait.CorrelationTrait;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.sql.engine.util.IndexConditions;
import org.apache.ignite.internal.sql.engine.util.RexUtils;
import org.apache.ignite.internal.util.CollectionUtils;

public class FilterSpoolMergeToSortedIndexSpoolRule
extends RelRule<Config> {
    public static final RelOptRule INSTANCE = Config.DEFAULT.toRule();

    private FilterSpoolMergeToSortedIndexSpoolRule(Config cfg) {
        super((RelRule.Config)cfg);
    }

    public void onMatch(RelOptRuleCall call) {
        RelNode input;
        IndexConditions idxCond;
        IgniteFilter filter = (IgniteFilter)call.rel(0);
        IgniteTableSpool spool = (IgniteTableSpool)call.rel(1);
        RelOptCluster cluster = spool.getCluster();
        RelTraitSet trait = spool.getTraitSet();
        CorrelationTrait filterCorr = TraitUtils.correlation((RelNode)filter);
        if (filterCorr.correlated()) {
            trait = trait.replace((RelTrait)filterCorr);
        }
        if (CollectionUtils.nullOrEmpty((idxCond = RexUtils.buildSortedIndexConditions(cluster, TraitUtils.collation(input = spool.getInput()), filter.getCondition(), spool.getRowType(), null)).lowerCondition()) && CollectionUtils.nullOrEmpty(idxCond.upperCondition())) {
            return;
        }
        RelCollation collation = TraitUtils.createCollation(idxCond.keys());
        IgniteSortedIndexSpool res = new IgniteSortedIndexSpool(cluster, trait.replace((RelTrait)collation), FilterSpoolMergeToSortedIndexSpoolRule.convert((RelNode)input, (RelTraitSet)input.getTraitSet().replace((RelTrait)collation)), collation, filter.getCondition(), idxCond);
        call.transformTo((RelNode)res);
    }

    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ((Config)RelRule.Config.EMPTY.withRelBuilderFactory(RelFactories.LOGICAL_BUILDER).withDescription("FilterSpoolMergeToSortedIndexSpoolRule").as(Config.class)).withOperandFor(IgniteFilter.class, IgniteTableSpool.class);

        default public Config withOperandFor(Class<? extends Filter> filterClass, Class<? extends Spool> spoolClass) {
            return (Config)this.withOperandSupplier(o0 -> o0.operand(filterClass).oneInput(o1 -> o1.operand(spoolClass).anyInputs())).as(Config.class);
        }

        default public FilterSpoolMergeToSortedIndexSpoolRule toRule() {
            return new FilterSpoolMergeToSortedIndexSpoolRule(this);
        }
    }
}

