/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rule.logical;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.sql.engine.rel.logical.IgniteLogicalTableScan;
import org.apache.ignite.internal.sql.engine.schema.InternalIgniteTable;

public class ExposeIndexRule
extends RelRule<Config> {
    public static final RelOptRule INSTANCE = Config.DEFAULT.toRule();

    public ExposeIndexRule(Config config) {
        super((RelRule.Config)config);
    }

    private static boolean preMatch(IgniteLogicalTableScan scan) {
        return !((InternalIgniteTable)scan.getTable().unwrap(InternalIgniteTable.class)).indexes().isEmpty();
    }

    public void onMatch(RelOptRuleCall call) {
        IgniteLogicalTableScan scan = (IgniteLogicalTableScan)call.rel(0);
        RelOptCluster cluster = scan.getCluster();
        RelOptTable optTable = scan.getTable();
        InternalIgniteTable igniteTable = (InternalIgniteTable)optTable.unwrap(InternalIgniteTable.class);
        List<RexNode> proj = scan.projects();
        RexNode condition = scan.condition();
        ImmutableBitSet requiredCols = scan.requiredColumns();
        List indexes = igniteTable.indexes().keySet().stream().map(idxName -> igniteTable.toRel(cluster, optTable, (String)idxName, proj, condition, requiredCols)).collect(Collectors.toList());
        if (indexes.isEmpty()) {
            return;
        }
        HashMap<RelNode, IgniteLogicalTableScan> equivMap = new HashMap<RelNode, IgniteLogicalTableScan>(indexes.size());
        for (int i = 1; i < indexes.size(); ++i) {
            equivMap.put((RelNode)indexes.get(i), scan);
        }
        call.transformTo((RelNode)indexes.get(0), equivMap);
    }

    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = (Config)EMPTY.withRelBuilderFactory(RelFactories.LOGICAL_BUILDER).withOperandSupplier(b -> b.operand(IgniteLogicalTableScan.class).predicate(x$0 -> ExposeIndexRule.preMatch(x$0)).anyInputs()).as(Config.class);

        default public ExposeIndexRule toRule() {
            return new ExposeIndexRule(this);
        }
    }
}

