/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rule.logical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.util.ControlFlowException;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite.internal.sql.engine.rel.ProjectableFilterableTableScan;
import org.apache.ignite.internal.sql.engine.rel.logical.IgniteLogicalIndexScan;
import org.apache.ignite.internal.sql.engine.rel.logical.IgniteLogicalTableScan;
import org.apache.ignite.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite.internal.sql.engine.trait.CorrelationTrait;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.RexUtils;
import org.apache.ignite.internal.util.CollectionUtils;

public abstract class FilterScanMergeRule<T extends ProjectableFilterableTableScan>
extends RelRule<Config> {
    public static final FilterScanMergeRule<IgniteLogicalIndexScan> INDEX_SCAN = new FilterScanMergeRule<IgniteLogicalIndexScan>(Config.INDEX_SCAN){

        @Override
        protected IgniteLogicalIndexScan createNode(RelOptCluster cluster, IgniteLogicalIndexScan scan, RelTraitSet traits, RexNode cond) {
            Set<CorrelationId> corrIds = RexUtils.extractCorrelationIds(cond);
            if (!CollectionUtils.nullOrEmpty(corrIds)) {
                traits = traits.replace((RelTrait)CorrelationTrait.correlations(corrIds));
            }
            return IgniteLogicalIndexScan.create(cluster, traits, scan.getTable(), scan.indexName(), scan.projects(), cond, scan.requiredColumns());
        }
    };
    public static final FilterScanMergeRule<IgniteLogicalTableScan> TABLE_SCAN = new FilterScanMergeRule<IgniteLogicalTableScan>(Config.TABLE_SCAN){

        @Override
        protected IgniteLogicalTableScan createNode(RelOptCluster cluster, IgniteLogicalTableScan scan, RelTraitSet traits, RexNode cond) {
            Set<CorrelationId> corrIds = RexUtils.extractCorrelationIds(cond);
            if (!CollectionUtils.nullOrEmpty(corrIds)) {
                traits = traits.replace((RelTrait)CorrelationTrait.correlations(corrIds));
            }
            return IgniteLogicalTableScan.create(cluster, traits, scan.getTable(), scan.projects(), cond, scan.requiredColumns());
        }
    };

    private FilterScanMergeRule(Config config) {
        super((RelRule.Config)config);
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalFilter filter = (LogicalFilter)call.rel(0);
        ProjectableFilterableTableScan scan = (ProjectableFilterableTableScan)call.rel(1);
        RelOptCluster cluster = scan.getCluster();
        RexBuilder builder = RexUtils.builder(cluster);
        RexNode condition = filter.getCondition();
        RexNode remaining = null;
        if (scan.condition() != null) {
            condition = RexUtil.composeConjunction((RexBuilder)builder, Arrays.asList(scan.condition(), condition));
        }
        if (scan.projects() != null) {
            IgniteTypeFactory typeFactory = Commons.typeFactory((RelNode)scan);
            IgniteTable tbl = (IgniteTable)scan.getTable().unwrap(IgniteTable.class);
            RelDataType cols = tbl.getRowType((RelDataTypeFactory)typeFactory, scan.requiredColumns());
            final Mappings.TargetMapping permutation = RexUtils.permutation(scan.projects(), cols, true);
            List conjunctions = RelOptUtil.conjunctions((RexNode)condition);
            ArrayList<RexNode> condition0 = new ArrayList<RexNode>(conjunctions.size());
            ArrayList<RexNode> remaining0 = new ArrayList<RexNode>(conjunctions.size());
            RexShuttle shuttle = new RexShuttle(){

                public RexNode visitInputRef(RexInputRef ref) {
                    int targetRef = permutation.getTargetOpt(ref.getIndex());
                    if (targetRef == -1) {
                        throw new ControlFlowException();
                    }
                    return new RexInputRef(targetRef, ref.getType());
                }
            };
            for (RexNode cond0 : conjunctions) {
                try {
                    condition0.add(shuttle.apply(cond0));
                }
                catch (ControlFlowException e) {
                    remaining0.add(cond0);
                }
            }
            condition = RexUtil.composeConjunction((RexBuilder)builder, condition0, (boolean)false);
            remaining = RexUtil.composeConjunction((RexBuilder)builder, remaining0, (boolean)true);
        }
        condition = RexUtils.replaceInputRefs(RexUtil.expandSearch((RexBuilder)builder, null, (RexNode)condition));
        RelTraitSet trait = scan.getTraitSet();
        CorrelationTrait filterCorr = TraitUtils.correlation((RelNode)filter);
        if (filterCorr.correlated()) {
            trait = trait.replace((RelTrait)filterCorr);
        }
        ProjectableFilterableTableScan res = this.createNode(cluster, scan, trait, condition);
        if (remaining != null) {
            res = this.relBuilderFactory.create(cluster, null).push((RelNode)res).filter(new RexNode[]{remaining}).build();
        }
        call.transformTo((RelNode)res);
    }

    protected abstract T createNode(RelOptCluster var1, T var2, RelTraitSet var3, RexNode var4);

    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = (Config)EMPTY.withRelBuilderFactory(RelFactories.LOGICAL_BUILDER).as(Config.class);
        public static final Config TABLE_SCAN = DEFAULT.withScanRuleConfig(IgniteLogicalTableScan.class, "FilterTableScanMergeRule");
        public static final Config INDEX_SCAN = DEFAULT.withScanRuleConfig(IgniteLogicalIndexScan.class, "FilterIndexScanMergeRule");

        default public Config withScanRuleConfig(Class<? extends ProjectableFilterableTableScan> scanCls, String desc) {
            return (Config)this.withDescription(desc).withOperandSupplier(b -> b.operand(LogicalFilter.class).oneInput(b1 -> b1.operand(scanCls).noInputs())).as(Config.class);
        }
    }
}

