/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rule.logical;

import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.tools.RelBuilder;

public class LogicalOrToUnionRule
extends RelRule<Config> {
    public static final RelOptRule INSTANCE = Config.DEFAULT.toRule();

    private LogicalOrToUnionRule(Config config) {
        super((RelRule.Config)config);
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalFilter rel = (LogicalFilter)call.rel(0);
        RelOptCluster cluster = rel.getCluster();
        RexNode dnf = RexUtil.toDnf((RexBuilder)cluster.getRexBuilder(), (RexNode)rel.getCondition());
        if (!dnf.isA(SqlKind.OR)) {
            return;
        }
        List operands = RelOptUtil.disjunctions((RexNode)dnf);
        if (operands.size() != 2 || RexUtil.find((SqlKind)SqlKind.IS_NULL).anyContain((Iterable)operands)) {
            return;
        }
        RelNode input = rel.getInput(0);
        RelNode rel0 = this.createUnionAll(cluster, input, (RexNode)operands.get(0), (RexNode)operands.get(1));
        call.transformTo(rel0, Map.of(this.createUnionAll(cluster, input, (RexNode)operands.get(1), (RexNode)operands.get(0)), rel0));
    }

    private RelNode createUnionAll(RelOptCluster cluster, RelNode input, RexNode op1, RexNode op2) {
        RelBuilder relBldr = this.relBuilderFactory.create(cluster, null);
        return relBldr.push(input).filter(new RexNode[]{op1}).push(input).filter(new RexNode[]{relBldr.and(new RexNode[]{op2, relBldr.or(new RexNode[]{relBldr.isNull(op1), relBldr.not(op1)})})}).union(true).build();
    }

    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ((Config)RelRule.Config.EMPTY.withRelBuilderFactory(RelFactories.LOGICAL_BUILDER).withDescription("LogicalOrToUnionRule").as(Config.class)).withOperandFor(LogicalFilter.class);

        default public Config withOperandFor(Class<? extends Filter> filterClass) {
            return (Config)this.withOperandSupplier(o -> o.operand(filterClass).anyInputs()).as(Config.class);
        }

        default public LogicalOrToUnionRule toRule() {
            return new LogicalOrToUnionRule(this);
        }
    }
}

