/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rule.logical;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite.internal.sql.engine.rel.ProjectableFilterableTableScan;
import org.apache.ignite.internal.sql.engine.rel.logical.IgniteLogicalIndexScan;
import org.apache.ignite.internal.sql.engine.rel.logical.IgniteLogicalTableScan;
import org.apache.ignite.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.RexUtils;

public abstract class ProjectScanMergeRule<T extends ProjectableFilterableTableScan>
extends RelRule<Config> {
    public static final ProjectScanMergeRule<IgniteLogicalIndexScan> INDEX_SCAN = new ProjectIndexScanMergeRule(Config.INDEX_SCAN);
    public static final ProjectScanMergeRule<IgniteLogicalIndexScan> INDEX_SCAN_SKIP_CORRELATED = new ProjectIndexScanMergeRule(Config.INDEX_SCAN_SKIP_CORRELATED);
    public static final ProjectScanMergeRule<IgniteLogicalTableScan> TABLE_SCAN = new ProjectTableScanMergeRule(Config.TABLE_SCAN);
    public static final ProjectScanMergeRule<IgniteLogicalTableScan> TABLE_SCAN_SKIP_CORRELATED = new ProjectTableScanMergeRule(Config.TABLE_SCAN_SKIP_CORRELATED);

    protected abstract T createNode(RelOptCluster var1, T var2, RelTraitSet var3, List<RexNode> var4, RexNode var5, ImmutableBitSet var6);

    private ProjectScanMergeRule(Config config) {
        super((RelRule.Config)config);
    }

    public boolean matches(RelOptRuleCall call) {
        ProjectableFilterableTableScan rel = (ProjectableFilterableTableScan)call.rel(1);
        return rel.requiredColumns() == null;
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalProject relProject = (LogicalProject)call.rel(0);
        ProjectableFilterableTableScan scan = (ProjectableFilterableTableScan)call.rel(1);
        RelOptCluster cluster = scan.getCluster();
        List projects = relProject.getProjects();
        RexNode cond = scan.condition();
        RelTraitSet traits = scan.getTraitSet();
        traits = traits.replace((RelTrait)TraitUtils.projectCollation(TraitUtils.collation(traits), projects, scan.getRowType()));
        traits = traits.replace((RelTrait)TraitUtils.projectDistribution(TraitUtils.distribution(traits), projects, scan.getRowType()));
        IgniteTable tbl = (IgniteTable)scan.getTable().unwrap(IgniteTable.class);
        IgniteTypeFactory typeFactory = Commons.typeFactory(cluster);
        final ImmutableBitSet.Builder builder = ImmutableBitSet.builder();
        new RexShuttle(){

            public RexNode visitInputRef(RexInputRef ref) {
                builder.set(ref.getIndex());
                return ref;
            }
        }.apply(projects);
        new RexShuttle(){

            public RexNode visitLocalRef(RexLocalRef inputRef) {
                builder.set(inputRef.getIndex());
                return inputRef;
            }
        }.apply(cond);
        ImmutableBitSet requiredColumns = builder.build();
        final Mappings.TargetMapping targetMapping = Commons.mapping(requiredColumns, tbl.getRowType((RelDataTypeFactory)typeFactory).getFieldCount());
        projects = new RexShuttle(){

            public RexNode visitInputRef(RexInputRef ref) {
                return new RexLocalRef(targetMapping.getTarget(ref.getIndex()), ref.getType());
            }
        }.apply(projects);
        if (RexUtils.isIdentity(projects, tbl.getRowType((RelDataTypeFactory)typeFactory, requiredColumns), true)) {
            projects = null;
        }
        cond = new RexShuttle(){

            public RexNode visitLocalRef(RexLocalRef ref) {
                return new RexLocalRef(targetMapping.getTarget(ref.getIndex()), ref.getType());
            }
        }.apply(cond);
        call.transformTo((RelNode)this.createNode(cluster, scan, traits, projects, cond, requiredColumns));
        if (!RexUtils.hasCorrelation(relProject.getProjects())) {
            cluster.getPlanner().prune((RelNode)relProject);
        }
    }

    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = (Config)EMPTY.withRelBuilderFactory(RelFactories.LOGICAL_BUILDER).as(Config.class);
        public static final Config TABLE_SCAN = DEFAULT.withScanRuleConfig(IgniteLogicalTableScan.class, "ProjectTableScanMergeRule", false);
        public static final Config TABLE_SCAN_SKIP_CORRELATED = DEFAULT.withScanRuleConfig(IgniteLogicalTableScan.class, "ProjectTableScanMergeSkipCorrelatedRule", true);
        public static final Config INDEX_SCAN = DEFAULT.withScanRuleConfig(IgniteLogicalIndexScan.class, "ProjectIndexScanMergeRule", false);
        public static final Config INDEX_SCAN_SKIP_CORRELATED = DEFAULT.withScanRuleConfig(IgniteLogicalIndexScan.class, "ProjectIndexScanMergeSkipCorrelatedRule", true);

        default public Config withScanRuleConfig(Class<? extends ProjectableFilterableTableScan> scanCls, String desc, boolean skipCorrelated) {
            return (Config)this.withDescription(desc).withOperandSupplier(b -> b.operand(LogicalProject.class).predicate(p -> !skipCorrelated || !RexUtils.hasCorrelation(p.getProjects())).oneInput(b1 -> b1.operand(scanCls).noInputs())).as(Config.class);
        }
    }

    private static class ProjectIndexScanMergeRule
    extends ProjectScanMergeRule<IgniteLogicalIndexScan> {
        private ProjectIndexScanMergeRule(Config config) {
            super(config);
        }

        @Override
        protected IgniteLogicalIndexScan createNode(RelOptCluster cluster, IgniteLogicalIndexScan scan, RelTraitSet traits, List<RexNode> projections, RexNode cond, ImmutableBitSet requiredColumns) {
            return IgniteLogicalIndexScan.create(cluster, traits, scan.getTable(), scan.indexName(), projections, cond, requiredColumns);
        }
    }

    private static class ProjectTableScanMergeRule
    extends ProjectScanMergeRule<IgniteLogicalTableScan> {
        private ProjectTableScanMergeRule(Config config) {
            super(config);
        }

        @Override
        protected IgniteLogicalTableScan createNode(RelOptCluster cluster, IgniteLogicalTableScan scan, RelTraitSet traits, List<RexNode> projections, RexNode cond, ImmutableBitSet requiredColumns) {
            return IgniteLogicalTableScan.create(cluster, traits, scan.getTable(), projections, cond, requiredColumns);
        }
    }
}

