/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.schema;

import java.util.function.Supplier;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.schema.NativeType;
import org.apache.ignite.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.jetbrains.annotations.Nullable;

public class ColumnDescriptorImpl
implements ColumnDescriptor {
    private final boolean key;
    private final String name;
    @Nullable
    private final Supplier<Object> dfltVal;
    private final int fieldIdx;
    private final NativeType storageType;

    public ColumnDescriptorImpl(String name, boolean key, int fieldIdx, NativeType storageType, @Nullable Supplier<Object> dfltVal) {
        this.key = key;
        this.name = name;
        this.dfltVal = dfltVal;
        this.fieldIdx = fieldIdx;
        this.storageType = storageType;
    }

    @Override
    public boolean key() {
        return this.key;
    }

    @Override
    public boolean hasDefaultValue() {
        return this.dfltVal != null;
    }

    @Override
    public Object defaultValue() {
        return this.dfltVal != null ? this.dfltVal.get() : null;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int fieldIndex() {
        return this.fieldIdx;
    }

    @Override
    public RelDataType logicalType(IgniteTypeFactory f) {
        return f.createJavaType(Commons.nativeTypeToClass(this.storageType));
    }

    @Override
    public NativeType storageType() {
        return this.storageType;
    }
}

