/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.schema;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.ignite.internal.sql.engine.schema.InternalIgniteTable;

public class IgniteSchema
extends AbstractSchema {
    private final String schemaName;
    private final Map<String, InternalIgniteTable> tblMap = new ConcurrentHashMap<String, InternalIgniteTable>();

    public IgniteSchema(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getName() {
        return this.schemaName;
    }

    protected Map<String, Table> getTableMap() {
        return Collections.unmodifiableMap(this.tblMap);
    }

    public void addTable(String tblName, InternalIgniteTable tbl) {
        this.tblMap.put(tblName, tbl);
    }

    public void removeTable(String tblName) {
        this.tblMap.remove(tblName);
    }
}

