/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.schema;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelReferentialConstraint;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.metadata.ColocationGroup;
import org.apache.ignite.internal.sql.engine.prepare.MappingQueryContext;
import org.apache.ignite.internal.sql.engine.rel.logical.IgniteLogicalIndexScan;
import org.apache.ignite.internal.sql.engine.rel.logical.IgniteLogicalTableScan;
import org.apache.ignite.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite.internal.sql.engine.schema.IgniteIndex;
import org.apache.ignite.internal.sql.engine.schema.InternalIgniteTable;
import org.apache.ignite.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite.internal.sql.engine.trait.RewindabilityTrait;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.table.TableImpl;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.table.Tuple;
import org.jetbrains.annotations.Nullable;

public class IgniteTableImpl
extends AbstractTable
implements InternalIgniteTable {
    private final TableDescriptor desc;
    private final TableImpl table;
    private final Statistic statistic;
    private final Map<String, IgniteIndex> indexes = new ConcurrentHashMap<String, IgniteIndex>();

    public IgniteTableImpl(TableDescriptor desc, TableImpl table) {
        this.desc = desc;
        this.table = table;
        this.statistic = new StatisticsImpl();
    }

    @Override
    public IgniteUuid id() {
        return this.table.tableId();
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory, ImmutableBitSet requiredColumns) {
        return this.desc.rowType((IgniteTypeFactory)typeFactory, requiredColumns);
    }

    @Override
    public Statistic getStatistic() {
        return this.statistic;
    }

    @Override
    public TableDescriptor descriptor() {
        return this.desc;
    }

    @Override
    public TableImpl table() {
        return this.table;
    }

    @Override
    public IgniteLogicalTableScan toRel(RelOptCluster cluster, RelOptTable relOptTbl, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable ImmutableBitSet requiredColumns) {
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)this.distribution()).replace((RelTrait)RewindabilityTrait.REWINDABLE);
        return IgniteLogicalTableScan.create(cluster, traitSet, relOptTbl, proj, cond, requiredColumns);
    }

    @Override
    public IgniteLogicalIndexScan toRel(RelOptCluster cluster, RelOptTable relOptTable, String idxName, List<RexNode> proj, RexNode condition, ImmutableBitSet requiredCols) {
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)Convention.Impl.NONE).replace((RelTrait)this.distribution()).replace((RelTrait)RewindabilityTrait.REWINDABLE).replace((RelTrait)this.getIndex(idxName).collation());
        return IgniteLogicalIndexScan.create(cluster, traitSet, relOptTable, idxName, proj, condition, requiredCols);
    }

    @Override
    public IgniteDistribution distribution() {
        return this.desc.distribution();
    }

    @Override
    public ColocationGroup colocationGroup(MappingQueryContext ctx) {
        return this.partitionedGroup();
    }

    @Override
    public Map<String, IgniteIndex> indexes() {
        return Collections.unmodifiableMap(this.indexes);
    }

    @Override
    public void addIndex(IgniteIndex idxTbl) {
        this.indexes.put(idxTbl.name(), idxTbl);
    }

    @Override
    public IgniteIndex getIndex(String idxName) {
        return this.indexes.get(idxName);
    }

    @Override
    public void removeIndex(String idxName) {
        this.indexes.remove(idxName);
    }

    @Override
    public <C> C unwrap(Class<C> cls) {
        if (cls.isInstance(this.desc)) {
            return cls.cast(this.desc);
        }
        return (C)super.unwrap(cls);
    }

    @Override
    public <RowT> RowT toRow(ExecutionContext<RowT> ectx, Tuple row, RowHandler.RowFactory<RowT> factory, @Nullable ImmutableBitSet requiredColumns) {
        RowHandler<RowT> handler = factory.handler();
        assert (handler == ectx.rowHandler());
        RowT res = factory.create();
        assert (handler.columnCount(res) == (requiredColumns == null ? this.desc.columnsCount() : requiredColumns.cardinality()));
        if (requiredColumns == null) {
            for (int i = 0; i < this.desc.columnsCount(); ++i) {
                ColumnDescriptor colDesc = this.desc.columnDescriptor(i);
                handler.set(i, res, row.value(colDesc.fieldIndex()));
            }
        } else {
            int i = 0;
            int j = requiredColumns.nextSetBit(0);
            while (j != -1) {
                ColumnDescriptor colDesc = this.desc.columnDescriptor(j);
                handler.set(i, res, row.value(colDesc.fieldIndex()));
                j = requiredColumns.nextSetBit(j + 1);
                ++i;
            }
        }
        return res;
    }

    @Override
    public <RowT> Tuple toTuple(ExecutionContext<RowT> ectx, RowT row, TableModify.Operation op, Object arg) {
        switch (op) {
            case INSERT: {
                return this.insertTuple(row, ectx);
            }
            case DELETE: {
                return this.deleteTuple(row, ectx);
            }
            case UPDATE: {
                return this.updateTuple(row, (List)arg, ectx);
            }
            case MERGE: {
                throw new UnsupportedOperationException();
            }
        }
        throw new AssertionError();
    }

    private <RowT> Tuple insertTuple(RowT row, ExecutionContext<RowT> ectx) {
        Tuple tuple = Tuple.create((int)this.desc.columnsCount());
        RowHandler<RowT> hnd = ectx.rowHandler();
        for (int i = 0; i < this.desc.columnsCount(); ++i) {
            tuple.set(this.desc.columnDescriptor(i).name(), hnd.get(i, row));
        }
        return tuple;
    }

    private <RowT> Tuple updateTuple(RowT row, List<String> updateColList, ExecutionContext<RowT> ectx) {
        int i;
        RowHandler<RowT> hnd = ectx.rowHandler();
        int offset = this.desc.columnsCount();
        Tuple tuple = Tuple.create((int)this.desc.columnsCount());
        HashSet<String> colsToSkip = new HashSet<String>(updateColList);
        for (i = 0; i < this.desc.columnsCount(); ++i) {
            String colName = this.desc.columnDescriptor(i).name();
            if (colsToSkip.contains(colName)) continue;
            tuple.set(colName, hnd.get(i, row));
        }
        for (i = 0; i < updateColList.size(); ++i) {
            ColumnDescriptor colDesc = Objects.requireNonNull(this.desc.columnDescriptor(updateColList.get(i)));
            assert (!colDesc.key());
            Object fieldVal = hnd.get(i + offset, row);
            tuple.set(colDesc.name(), fieldVal);
        }
        return tuple;
    }

    private <RowT> Tuple deleteTuple(RowT row, ExecutionContext<RowT> ectx) {
        RowHandler<RowT> hnd = ectx.rowHandler();
        Tuple tuple = Tuple.create();
        int idx = 0;
        for (int i = 0; i < this.desc.columnsCount(); ++i) {
            ColumnDescriptor colDesc = this.desc.columnDescriptor(i);
            if (!colDesc.key()) continue;
            tuple.set(colDesc.name(), hnd.get(idx++, row));
        }
        return tuple;
    }

    private ColocationGroup partitionedGroup() {
        List<List<String>> assignments = this.table.internalTable().assignments().stream().map(Collections::singletonList).collect(Collectors.toList());
        return ColocationGroup.forAssignments(assignments);
    }

    private class StatisticsImpl
    implements Statistic {
        private StatisticsImpl() {
        }

        public Double getRowCount() {
            return 10000.0;
        }

        public boolean isKey(ImmutableBitSet cols) {
            return false;
        }

        public List<ImmutableBitSet> getKeys() {
            return null;
        }

        public List<RelReferentialConstraint> getReferentialConstraints() {
            return List.of();
        }

        public List<RelCollation> getCollations() {
            return List.of();
        }

        public IgniteDistribution getDistribution() {
            return IgniteTableImpl.this.distribution();
        }
    }
}

