/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.schema;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.tools.Frameworks;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.sql.engine.extension.SqlExtension;
import org.apache.ignite.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite.internal.sql.engine.schema.ColumnDescriptorImpl;
import org.apache.ignite.internal.sql.engine.schema.IgniteSchema;
import org.apache.ignite.internal.sql.engine.schema.IgniteTableImpl;
import org.apache.ignite.internal.sql.engine.schema.InternalIgniteTable;
import org.apache.ignite.internal.sql.engine.schema.SqlSchemaManager;
import org.apache.ignite.internal.sql.engine.schema.TableDescriptorImpl;
import org.apache.ignite.internal.table.TableImpl;
import org.apache.ignite.internal.table.distributed.TableManager;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.lang.IgniteStringFormatter;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.lang.NodeStoppingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlSchemaManagerImpl
implements SqlSchemaManager {
    private final Map<String, IgniteSchema> igniteSchemas = new HashMap<String, IgniteSchema>();
    private final Map<IgniteUuid, InternalIgniteTable> tablesById = new ConcurrentHashMap<IgniteUuid, InternalIgniteTable>();
    private final Map<String, Schema> externalCatalogs = new HashMap<String, Schema>();
    private final Runnable onSchemaUpdatedCallback;
    private final TableManager tableManager;
    private volatile SchemaPlus calciteSchema;

    public SqlSchemaManagerImpl(TableManager tableManager, Runnable onSchemaUpdatedCallback) {
        this.onSchemaUpdatedCallback = onSchemaUpdatedCallback;
        this.tableManager = tableManager;
        SchemaPlus newCalciteSchema = Frameworks.createRootSchema((boolean)false);
        newCalciteSchema.add("PUBLIC", (Schema)new IgniteSchema("PUBLIC"));
        this.calciteSchema = newCalciteSchema;
    }

    @Override
    public SchemaPlus schema(@Nullable String schema) {
        return schema != null ? this.calciteSchema.getSubSchema(schema) : this.calciteSchema;
    }

    @Override
    @NotNull
    public InternalIgniteTable tableById(IgniteUuid id) {
        InternalIgniteTable table = this.tablesById.get(id);
        if (table == null) {
            this.ensureTableStructuresCreated(id);
            table = this.tablesById.get(id);
        }
        if (table == null) {
            throw new IgniteInternalException(IgniteStringFormatter.format((String)"Table not found [tableId={}]", (Object[])new Object[]{id}));
        }
        return table;
    }

    private void ensureTableStructuresCreated(IgniteUuid id) {
        try {
            this.tableManager.table(id);
        }
        catch (NodeStoppingException nodeStoppingException) {
            // empty catch block
        }
    }

    public synchronized void registerExternalCatalog(String name, SqlExtension.ExternalCatalog catalog) {
        catalog.schemaNames().forEach(schemaName -> this.registerExternalSchema(name, (String)schemaName, catalog.schema((String)schemaName)));
        this.rebuild();
    }

    private void registerExternalSchema(String catalogName, String schemaName, SqlExtension.ExternalSchema schema) {
        HashMap<String, Table> tables = new HashMap<String, Table>();
        schema.tableNames().forEach(name -> tables.put((String)name, (Table)schema.table((String)name)));
        SchemaPlus schemaPlus = (SchemaPlus)this.externalCatalogs.computeIfAbsent(catalogName, n -> Frameworks.createRootSchema((boolean)false));
        schemaPlus.add(schemaName, (Schema)new ExternalSchemaHolder(tables));
    }

    public synchronized void onSchemaCreated(String schemaName) {
        this.igniteSchemas.putIfAbsent(schemaName, new IgniteSchema(schemaName));
        this.rebuild();
    }

    public synchronized void onSchemaDropped(String schemaName) {
        this.igniteSchemas.remove(schemaName);
        this.rebuild();
    }

    public synchronized void onTableCreated(String schemaName, TableImpl table) {
        IgniteSchema schema = this.igniteSchemas.computeIfAbsent(schemaName, IgniteSchema::new);
        SchemaDescriptor descriptor = table.schemaView().schema();
        List<ColumnDescriptor> colDescriptors = descriptor.columnNames().stream().map(arg_0 -> ((SchemaDescriptor)descriptor).column(arg_0)).sorted(Comparator.comparingInt(Column::columnOrder)).map(col -> new ColumnDescriptorImpl(col.name(), descriptor.isKeyColumn(col.schemaIndex()), col.schemaIndex(), col.type(), () -> ((Column)col).defaultValue())).collect(Collectors.toList());
        TableDescriptorImpl desc = new TableDescriptorImpl(colDescriptors);
        IgniteTableImpl table0 = new IgniteTableImpl(desc, table);
        schema.addTable(SqlSchemaManagerImpl.removeSchema(schemaName, table.name()), table0);
        this.tablesById.put(table0.id(), table0);
        this.rebuild();
    }

    public void onTableUpdated(String schemaName, TableImpl table) {
        this.onTableCreated(schemaName, table);
    }

    public synchronized void onTableDropped(String schemaName, String tableName) {
        IgniteSchema schema = this.igniteSchemas.computeIfAbsent(schemaName, IgniteSchema::new);
        InternalIgniteTable table = (InternalIgniteTable)schema.getTable(tableName);
        if (table != null) {
            this.tablesById.remove(table.id());
            schema.removeTable(tableName);
        }
        this.rebuild();
    }

    private void rebuild() {
        SchemaPlus newCalciteSchema = Frameworks.createRootSchema((boolean)false);
        newCalciteSchema.add("PUBLIC", (Schema)new IgniteSchema("PUBLIC"));
        this.igniteSchemas.forEach((arg_0, arg_1) -> ((SchemaPlus)newCalciteSchema).add(arg_0, arg_1));
        this.externalCatalogs.forEach((arg_0, arg_1) -> ((SchemaPlus)newCalciteSchema).add(arg_0, arg_1));
        this.calciteSchema = newCalciteSchema;
        this.onSchemaUpdatedCallback.run();
    }

    private static String removeSchema(String schemaName, String canonicalName) {
        return canonicalName.substring(schemaName.length() + 1);
    }

    private static class ExternalSchemaHolder
    extends AbstractSchema {
        private final Map<String, Table> tables;

        public ExternalSchemaHolder(Map<String, Table> tables) {
            this.tables = tables;
        }

        protected Map<String, Table> getTableMap() {
            return this.tables;
        }
    }
}

