/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.schema;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.ColumnStrategy;
import org.apache.calcite.sql2rel.InitializerContext;
import org.apache.calcite.sql2rel.NullInitializerExpressionFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;

public class TableDescriptorImpl
extends NullInitializerExpressionFactory
implements TableDescriptor {
    private static final ColumnDescriptor[] DUMMY = new ColumnDescriptor[0];
    private final ColumnDescriptor[] descriptors;
    private final Map<String, ColumnDescriptor> descriptorsMap;
    private final ImmutableBitSet insertFields;
    private final ImmutableBitSet keyFields;

    public TableDescriptorImpl(List<ColumnDescriptor> columnDescriptors) {
        ImmutableBitSet.Builder keyFieldsBuilder = ImmutableBitSet.builder();
        HashMap<String, ColumnDescriptor> descriptorsMap = new HashMap<String, ColumnDescriptor>(columnDescriptors.size());
        for (ColumnDescriptor descriptor : columnDescriptors) {
            descriptorsMap.put(descriptor.name(), descriptor);
            if (!descriptor.key()) continue;
            keyFieldsBuilder.set(descriptor.fieldIndex());
        }
        this.descriptors = columnDescriptors.toArray(DUMMY);
        this.descriptorsMap = descriptorsMap;
        this.insertFields = ImmutableBitSet.range((int)columnDescriptors.size());
        this.keyFields = keyFieldsBuilder.build();
    }

    @Override
    public RelDataType insertRowType(IgniteTypeFactory factory) {
        return this.rowType(factory, this.insertFields);
    }

    @Override
    public RelDataType deleteRowType(IgniteTypeFactory factory) {
        return this.rowType(factory, this.keyFields);
    }

    @Override
    public IgniteDistribution distribution() {
        return IgniteDistributions.random();
    }

    @Override
    public boolean isUpdateAllowed(RelOptTable tbl, int colIdx) {
        return !this.descriptors[colIdx].key();
    }

    public ColumnStrategy generationStrategy(RelOptTable tbl, int colIdx) {
        if (this.descriptors[colIdx].hasDefaultValue()) {
            return ColumnStrategy.DEFAULT;
        }
        return super.generationStrategy(tbl, colIdx);
    }

    public RexNode newColumnDefaultValue(RelOptTable tbl, int colIdx, InitializerContext ctx) {
        ColumnDescriptor desc = this.descriptors[colIdx];
        if (!desc.hasDefaultValue()) {
            return super.newColumnDefaultValue(tbl, colIdx, ctx);
        }
        RexBuilder rexBuilder = ctx.getRexBuilder();
        IgniteTypeFactory typeFactory = (IgniteTypeFactory)rexBuilder.getTypeFactory();
        return rexBuilder.makeLiteral(desc.defaultValue(), desc.logicalType(typeFactory), false);
    }

    @Override
    public RelDataType rowType(IgniteTypeFactory factory, ImmutableBitSet usedColumns) {
        RelDataTypeFactory.Builder b = new RelDataTypeFactory.Builder((RelDataTypeFactory)factory);
        if (usedColumns == null) {
            for (int i = 0; i < this.descriptors.length; ++i) {
                b.add(this.descriptors[i].name(), this.descriptors[i].logicalType(factory));
            }
        } else {
            int i = usedColumns.nextSetBit(0);
            while (i != -1) {
                b.add(this.descriptors[i].name(), this.descriptors[i].logicalType(factory));
                i = usedColumns.nextSetBit(i + 1);
            }
        }
        return TypeUtils.sqlType(factory, b.build());
    }

    @Override
    public ColumnDescriptor columnDescriptor(String fieldName) {
        return fieldName == null ? null : this.descriptorsMap.get(fieldName);
    }

    @Override
    public ColumnDescriptor columnDescriptor(int idx) {
        return idx < 0 || idx >= this.descriptors.length ? null : this.descriptors[idx];
    }

    @Override
    public int columnsCount() {
        return this.descriptors.length;
    }
}

