/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.type;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.runtime.Geometries;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.IntervalSqlType;
import org.apache.ignite.internal.schema.configuration.SchemaConfigurationConverter;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeSystem;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.schema.definition.ColumnType;

public class IgniteTypeFactory
extends JavaTypeFactoryImpl {
    public IgniteTypeFactory() {
        super(IgniteTypeSystem.INSTANCE);
    }

    public IgniteTypeFactory(RelDataTypeSystem typeSystem) {
        super(typeSystem);
    }

    public Type getJavaClass(RelDataType type) {
        if (type instanceof RelDataTypeFactoryImpl.JavaType) {
            return ((RelDataTypeFactoryImpl.JavaType)type).getJavaClass();
        }
        if (type instanceof BasicSqlType || type instanceof IntervalSqlType) {
            switch (type.getSqlTypeName()) {
                case VARCHAR: 
                case CHAR: {
                    return String.class;
                }
                case DATE: 
                case TIME: 
                case TIME_WITH_LOCAL_TIME_ZONE: 
                case INTEGER: 
                case INTERVAL_YEAR: 
                case INTERVAL_YEAR_MONTH: 
                case INTERVAL_MONTH: {
                    return type.isNullable() ? Integer.class : Integer.TYPE;
                }
                case TIMESTAMP: 
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
                case BIGINT: 
                case INTERVAL_DAY: 
                case INTERVAL_DAY_HOUR: 
                case INTERVAL_DAY_MINUTE: 
                case INTERVAL_DAY_SECOND: 
                case INTERVAL_HOUR: 
                case INTERVAL_HOUR_MINUTE: 
                case INTERVAL_HOUR_SECOND: 
                case INTERVAL_MINUTE: 
                case INTERVAL_MINUTE_SECOND: 
                case INTERVAL_SECOND: {
                    return type.isNullable() ? Long.class : Long.TYPE;
                }
                case SMALLINT: {
                    return type.isNullable() ? Short.class : Short.TYPE;
                }
                case TINYINT: {
                    return type.isNullable() ? Byte.class : Byte.TYPE;
                }
                case DECIMAL: {
                    return BigDecimal.class;
                }
                case BOOLEAN: {
                    return type.isNullable() ? Boolean.class : Boolean.TYPE;
                }
                case DOUBLE: {
                    return type.isNullable() ? Double.class : Double.TYPE;
                }
                case REAL: 
                case FLOAT: {
                    return type.isNullable() ? Float.class : Float.TYPE;
                }
                case BINARY: 
                case VARBINARY: {
                    return ByteString.class;
                }
                case GEOMETRY: {
                    return Geometries.Geom.class;
                }
                case SYMBOL: {
                    return Enum.class;
                }
                case ANY: 
                case OTHER: {
                    return Object.class;
                }
                case NULL: {
                    return Void.class;
                }
            }
        }
        switch (type.getSqlTypeName()) {
            case ROW: {
                return Object[].class;
            }
            case MAP: {
                return Map.class;
            }
            case ARRAY: 
            case MULTISET: {
                return List.class;
            }
        }
        return null;
    }

    public ColumnType columnType(RelDataType relType) {
        assert (relType != null);
        Type javaType = this.getResultClass(relType);
        if (javaType == byte[].class) {
            return relType.getPrecision() == -1 ? ColumnType.blobOf() : ColumnType.blobOf((int)relType.getPrecision());
        }
        if (javaType == String.class) {
            return relType.getPrecision() == -1 ? ColumnType.string() : ColumnType.stringOf((int)relType.getPrecision());
        }
        if (javaType == BigInteger.class) {
            return relType.getPrecision() == -1 ? ColumnType.numberOf() : ColumnType.numberOf((int)relType.getPrecision());
        }
        if (javaType == BigDecimal.class) {
            return relType.getPrecision() == -1 ? ColumnType.decimalOf() : ColumnType.decimalOf((int)relType.getPrecision(), (int)relType.getScale());
        }
        return SchemaConfigurationConverter.columnType((Class)((Class)javaType));
    }

    public Type getResultClass(RelDataType type) {
        if (type instanceof RelDataTypeFactoryImpl.JavaType) {
            return ((RelDataTypeFactoryImpl.JavaType)type).getJavaClass();
        }
        if (type instanceof BasicSqlType || type instanceof IntervalSqlType) {
            switch (type.getSqlTypeName()) {
                case VARCHAR: 
                case CHAR: {
                    return String.class;
                }
                case DATE: {
                    return Date.class;
                }
                case TIME: {
                    return Time.class;
                }
                case TIMESTAMP: {
                    return Timestamp.class;
                }
                case TIME_WITH_LOCAL_TIME_ZONE: {
                    return LocalTime.class;
                }
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                    return LocalDateTime.class;
                }
                case INTEGER: 
                case INTERVAL_YEAR: 
                case INTERVAL_YEAR_MONTH: 
                case INTERVAL_MONTH: {
                    return type.isNullable() ? Integer.class : Integer.TYPE;
                }
                case BIGINT: 
                case INTERVAL_DAY: 
                case INTERVAL_DAY_HOUR: 
                case INTERVAL_DAY_MINUTE: 
                case INTERVAL_DAY_SECOND: 
                case INTERVAL_HOUR: 
                case INTERVAL_HOUR_MINUTE: 
                case INTERVAL_HOUR_SECOND: 
                case INTERVAL_MINUTE: 
                case INTERVAL_MINUTE_SECOND: 
                case INTERVAL_SECOND: {
                    return type.isNullable() ? Long.class : Long.TYPE;
                }
                case SMALLINT: {
                    return type.isNullable() ? Short.class : Short.TYPE;
                }
                case TINYINT: {
                    return type.isNullable() ? Byte.class : Byte.TYPE;
                }
                case DECIMAL: {
                    return BigDecimal.class;
                }
                case BOOLEAN: {
                    return type.isNullable() ? Boolean.class : Boolean.TYPE;
                }
                case DOUBLE: {
                    return type.isNullable() ? Double.class : Double.TYPE;
                }
                case REAL: 
                case FLOAT: {
                    return type.isNullable() ? Float.class : Float.TYPE;
                }
                case BINARY: 
                case VARBINARY: {
                    return byte[].class;
                }
                case GEOMETRY: {
                    return Geometries.Geom.class;
                }
                case SYMBOL: {
                    return Enum.class;
                }
                case ANY: 
                case OTHER: {
                    return Object.class;
                }
                case NULL: {
                    return Void.class;
                }
            }
        }
        switch (type.getSqlTypeName()) {
            case ROW: {
                return Object[].class;
            }
            case MAP: {
                return Map.class;
            }
            case ARRAY: 
            case MULTISET: {
                return List.class;
            }
        }
        return null;
    }

    public RelDataType leastRestrictive(List<RelDataType> types) {
        assert (types != null);
        assert (types.size() >= 1);
        if (types.size() == 1 || this.allEquals(types)) {
            return (RelDataType)CollectionUtils.first(types);
        }
        return super.leastRestrictive(types);
    }

    public Charset getDefaultCharset() {
        Charset jvmDefault = Charset.defaultCharset();
        if (SqlUtil.translateCharacterSetName((String)jvmDefault.name().toUpperCase(Locale.ROOT)) == null) {
            jvmDefault = StandardCharsets.UTF_8;
        }
        return jvmDefault;
    }

    private boolean allEquals(List<RelDataType> types) {
        assert (types.size() > 1);
        RelDataType first = (RelDataType)CollectionUtils.first(types);
        for (int i = 1; i < types.size(); ++i) {
            if (Objects.equals(first, types.get(i))) continue;
            return false;
        }
        return true;
    }
}

