/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCostFactory;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rel.metadata.CachingRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.ignite.internal.sql.engine.QueryCancel;
import org.apache.ignite.internal.sql.engine.extension.SqlExtension;
import org.apache.ignite.internal.sql.engine.metadata.IgniteMetadata;
import org.apache.ignite.internal.sql.engine.metadata.RelMetadataQueryEx;
import org.apache.ignite.internal.sql.engine.metadata.cost.IgniteCostFactory;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.AbstractQueryContext;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.lang.IgniteLogger;
import org.apache.ignite.logger.NullLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BaseQueryContext
extends AbstractQueryContext {
    public static final CalciteConnectionConfig CALCITE_CONNECTION_CONFIG;
    public static final RelOptCluster CLUSTER;
    private static final IgniteTypeFactory TYPE_FACTORY;
    private static final IgniteCostFactory COST_FACTORY;
    private static final BaseQueryContext EMPTY_CONTEXT;
    private static final VolcanoPlanner DUMMY_PLANNER;
    private static final RexBuilder DFLT_REX_BUILDER;
    private final FrameworkConfig cfg;
    private final IgniteLogger log;
    private final IgniteTypeFactory typeFactory;
    private final RexBuilder rexBuilder;
    private final QueryCancel qryCancel;
    private final Map<String, SqlExtension> extensions;
    private CalciteCatalogReader catalogReader;

    public static RelOptCluster createCluster() {
        RelOptCluster cluster = RelOptCluster.create((RelOptPlanner)new VolcanoPlanner((RelOptCostFactory)COST_FACTORY, (Context)EMPTY_CONTEXT), (RexBuilder)DFLT_REX_BUILDER);
        cluster.setMetadataProvider((RelMetadataProvider)new CachingRelMetadataProvider(IgniteMetadata.METADATA_PROVIDER, cluster.getPlanner()));
        cluster.setMetadataQuerySupplier(RelMetadataQueryEx::create);
        return cluster;
    }

    private BaseQueryContext(FrameworkConfig cfg, Context parentCtx, IgniteLogger log, Map<String, SqlExtension> extensions) {
        super(Contexts.chain((Context[])new Context[]{parentCtx, cfg.getContext()}));
        this.cfg = Frameworks.newConfigBuilder((FrameworkConfig)cfg).context((Context)this).build();
        this.log = log;
        this.extensions = extensions;
        RelDataTypeSystem typeSys = (RelDataTypeSystem)CALCITE_CONNECTION_CONFIG.typeSystem(RelDataTypeSystem.class, (Object)cfg.getTypeSystem());
        this.typeFactory = new IgniteTypeFactory(typeSys);
        this.qryCancel = this.unwrap(QueryCancel.class);
        this.rexBuilder = new RexBuilder((RelDataTypeFactory)this.typeFactory);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static BaseQueryContext empty() {
        return EMPTY_CONTEXT;
    }

    public List<SqlExtension> extensions() {
        return new ArrayList<SqlExtension>(this.extensions.values());
    }

    @Nullable
    public SqlExtension extension(String name) {
        return this.extensions.get(name);
    }

    public FrameworkConfig config() {
        return this.cfg;
    }

    public IgniteLogger logger() {
        return this.log;
    }

    public String schemaName() {
        return this.schema().getName();
    }

    public SchemaPlus schema() {
        return this.cfg.getDefaultSchema();
    }

    public IgniteTypeFactory typeFactory() {
        return this.typeFactory;
    }

    public RexBuilder rexBuilder() {
        return this.rexBuilder;
    }

    public CalciteCatalogReader catalogReader() {
        SchemaPlus dfltSchema;
        if (this.catalogReader != null) {
            return this.catalogReader;
        }
        SchemaPlus rootSchema = dfltSchema = this.schema();
        while (rootSchema.getParentSchema() != null) {
            rootSchema = rootSchema.getParentSchema();
        }
        this.catalogReader = new CalciteCatalogReader(CalciteSchema.from((SchemaPlus)rootSchema), CalciteSchema.from((SchemaPlus)dfltSchema).path(null), (RelDataTypeFactory)this.typeFactory(), CALCITE_CONNECTION_CONFIG);
        return this.catalogReader;
    }

    public QueryCancel queryCancel() {
        return this.qryCancel;
    }

    static {
        COST_FACTORY = new IgniteCostFactory();
        Properties props = new Properties();
        props.setProperty(CalciteConnectionProperty.CASE_SENSITIVE.camelName(), String.valueOf(Commons.FRAMEWORK_CONFIG.getParserConfig().caseSensitive()));
        props.setProperty(CalciteConnectionProperty.CONFORMANCE.camelName(), String.valueOf(Commons.FRAMEWORK_CONFIG.getParserConfig().conformance()));
        props.setProperty(CalciteConnectionProperty.MATERIALIZATIONS_ENABLED.camelName(), String.valueOf(true));
        CALCITE_CONNECTION_CONFIG = new CalciteConnectionConfigImpl(props);
        EMPTY_CONTEXT = BaseQueryContext.builder().build();
        DUMMY_PLANNER = new VolcanoPlanner(COST_FACTORY, EMPTY_CONTEXT){

            public void registerSchema(RelOptSchema schema) {
                throw new UnsupportedOperationException("Dummy planer. Please use a specific instance.");
            }
        };
        RelDataTypeSystem typeSys = (RelDataTypeSystem)CALCITE_CONNECTION_CONFIG.typeSystem(RelDataTypeSystem.class, (Object)Commons.FRAMEWORK_CONFIG.getTypeSystem());
        TYPE_FACTORY = new IgniteTypeFactory(typeSys);
        DFLT_REX_BUILDER = new RexBuilder((RelDataTypeFactory)TYPE_FACTORY);
        RelOptCluster cluster = RelOptCluster.create((RelOptPlanner)DUMMY_PLANNER, (RexBuilder)DFLT_REX_BUILDER);
        cluster.setMetadataProvider(IgniteMetadata.METADATA_PROVIDER);
        CLUSTER = cluster;
    }

    public static class Builder {
        private static final FrameworkConfig EMPTY_CONFIG = Frameworks.newConfigBuilder((FrameworkConfig)Commons.FRAMEWORK_CONFIG).defaultSchema(Frameworks.createRootSchema((boolean)false)).build();
        private FrameworkConfig frameworkCfg = EMPTY_CONFIG;
        private Context parentCtx = Contexts.empty();
        private IgniteLogger log = new NullLogger();
        private Map<String, SqlExtension> extensions = Collections.emptyMap();

        public Builder frameworkConfig(@NotNull FrameworkConfig frameworkCfg) {
            this.frameworkCfg = frameworkCfg;
            return this;
        }

        public Builder parentContext(@NotNull Context parentCtx) {
            this.parentCtx = parentCtx;
            return this;
        }

        public Builder logger(@NotNull IgniteLogger log) {
            this.log = log;
            return this;
        }

        public Builder extensions(Map<String, SqlExtension> extensions) {
            this.extensions = extensions;
            return this;
        }

        public BaseQueryContext build() {
            return new BaseQueryContext(this.frameworkCfg, this.parentCtx, this.log, this.extensions);
        }
    }
}

