/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.calcite.DataContexts;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.config.Lex;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCostFactory;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.hint.HintStrategyTable;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.fun.SqlLibrary;
import org.apache.calcite.sql.fun.SqlLibraryOperatorTableFactory;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.util.SqlOperatorTables;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.SourceStringReader;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite.internal.generated.query.calcite.sql.IgniteSqlParserImpl;
import org.apache.ignite.internal.schema.BitmaskNativeType;
import org.apache.ignite.internal.schema.DecimalNativeType;
import org.apache.ignite.internal.schema.NativeType;
import org.apache.ignite.internal.schema.NumberNativeType;
import org.apache.ignite.internal.schema.TemporalNativeType;
import org.apache.ignite.internal.schema.VarlenNativeType;
import org.apache.ignite.internal.sql.engine.ResultSetMetadata;
import org.apache.ignite.internal.sql.engine.SqlCursor;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.exp.ExpressionFactoryImpl;
import org.apache.ignite.internal.sql.engine.exec.exp.RexExecutorImpl;
import org.apache.ignite.internal.sql.engine.metadata.cost.IgniteCostFactory;
import org.apache.ignite.internal.sql.engine.prepare.AbstractMultiStepPlan;
import org.apache.ignite.internal.sql.engine.prepare.ExplainPlan;
import org.apache.ignite.internal.sql.engine.prepare.MultiStepPlan;
import org.apache.ignite.internal.sql.engine.prepare.PlanningContext;
import org.apache.ignite.internal.sql.engine.prepare.QueryPlan;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlConformance;
import org.apache.ignite.internal.sql.engine.sql.fun.IgniteSqlOperatorTable;
import org.apache.ignite.internal.sql.engine.trait.CorrelationTraitDef;
import org.apache.ignite.internal.sql.engine.trait.DistributionTraitDef;
import org.apache.ignite.internal.sql.engine.trait.RewindabilityTraitDef;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeSystem;
import org.apache.ignite.internal.sql.engine.util.BaseQueryContext;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.lang.IgniteLogger;
import org.codehaus.commons.compiler.CompilerFactoryFactory;
import org.codehaus.commons.compiler.IClassBodyEvaluator;
import org.codehaus.commons.compiler.ICompilerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Commons {
    public static final int IN_BUFFER_SIZE = 512;
    public static final FrameworkConfig FRAMEWORK_CONFIG = Frameworks.newConfigBuilder().executor((RexExecutor)new RexExecutorImpl(DataContexts.EMPTY)).sqlToRelConverterConfig(SqlToRelConverter.config().withTrimUnusedFields(true).withInSubQueryThreshold(Integer.MAX_VALUE).withDecorrelationEnabled(true).withExpand(false).withHintStrategyTable(HintStrategyTable.builder().hintStrategy("DISABLE_RULE", (hint, rel) -> true).hintStrategy("EXPAND_DISTINCT_AGG", (hint, rel) -> rel instanceof Aggregate).build())).parserConfig(SqlParser.config().withParserFactory(IgniteSqlParserImpl.FACTORY).withLex(Lex.ORACLE).withConformance(IgniteSqlConformance.INSTANCE)).sqlValidatorConfig(SqlValidator.Config.DEFAULT.withIdentifierExpansion(true).withDefaultNullCollation(NullCollation.LOW).withSqlConformance(IgniteSqlConformance.INSTANCE)).operatorTable(SqlOperatorTables.chain((SqlOperatorTable[])new SqlOperatorTable[]{SqlLibraryOperatorTableFactory.INSTANCE.getOperatorTable(new SqlLibrary[]{SqlLibrary.STANDARD, SqlLibrary.POSTGRESQL, SqlLibrary.ORACLE, SqlLibrary.MYSQL}), IgniteSqlOperatorTable.instance()})).context(Contexts.empty()).costFactory((RelOptCostFactory)new IgniteCostFactory()).typeSystem(IgniteTypeSystem.INSTANCE).traitDefs(new RelTraitDef[]{ConventionTraitDef.INSTANCE, RelCollationTraitDef.INSTANCE, DistributionTraitDef.INSTANCE, RewindabilityTraitDef.INSTANCE, CorrelationTraitDef.INSTANCE}).build();

    private Commons() {
    }

    public static <T> SqlCursor<T> createCursor(Iterable<T> iterable, QueryPlan plan) {
        return Commons.createCursor(iterable.iterator(), plan);
    }

    public static <T> SqlCursor<T> createCursor(final Iterator<T> iter, final QueryPlan plan) {
        return new SqlCursor<T>(){

            @Override
            public SqlQueryType queryType() {
                return SqlQueryType.mapPlanTypeToSqlType(plan.type());
            }

            @Override
            public ResultSetMetadata metadata() {
                return plan instanceof AbstractMultiStepPlan ? ((MultiStepPlan)plan).metadata() : ((ExplainPlan)plan).metadata();
            }

            public void remove() {
                iter.remove();
            }

            public boolean hasNext() {
                return iter.hasNext();
            }

            public T next() {
                return iter.next();
            }

            @NotNull
            public Iterator<T> iterator() {
                return iter;
            }

            public void close() throws Exception {
                if (iter instanceof AutoCloseable) {
                    ((AutoCloseable)((Object)iter)).close();
                }
            }
        };
    }

    public static <RowT> Object getFieldFromBiRows(RowHandler<RowT> hnd, int offset, RowT row1, RowT row2) {
        return offset < hnd.columnCount(row1) ? hnd.get(offset, row1) : hnd.get(offset - hnd.columnCount(row1), row2);
    }

    public static <T> List<T> combine(List<T> left, List<T> right) {
        HashSet<T> set = new HashSet<T>(left.size() + right.size());
        set.addAll(left);
        set.addAll(right);
        return new ArrayList(set);
    }

    public static <T> List<T> intersect(List<T> left, List<T> right) {
        if (CollectionUtils.nullOrEmpty(left) || CollectionUtils.nullOrEmpty(right)) {
            return Collections.emptyList();
        }
        return left.size() > right.size() ? Commons.intersect(new HashSet<T>(right), left) : Commons.intersect(new HashSet<T>(left), right);
    }

    public static <T> List<T> intersect(Set<T> set, List<T> list) {
        if (CollectionUtils.nullOrEmpty(set) || CollectionUtils.nullOrEmpty(list)) {
            return Collections.emptyList();
        }
        return list.stream().filter(set::contains).collect(Collectors.toList());
    }

    public static <T> List<T> cast(List<?> src) {
        return src;
    }

    public static <T, R> List<R> transform(@NotNull List<T> src, @NotNull Function<T, R> mapFun) {
        if (CollectionUtils.nullOrEmpty(src)) {
            return Collections.emptyList();
        }
        ArrayList<R> list = new ArrayList<R>(src.size());
        for (T t : src) {
            list.add(mapFun.apply(t));
        }
        return list;
    }

    public static IgniteTypeFactory typeFactory(RelNode rel) {
        return Commons.typeFactory(rel.getCluster());
    }

    public static IgniteTypeFactory typeFactory(RelOptCluster cluster) {
        return (IgniteTypeFactory)cluster.getTypeFactory();
    }

    public static IgniteTypeFactory typeFactory() {
        return Commons.typeFactory(Commons.cluster());
    }

    public static BaseQueryContext context(RelNode rel) {
        return Commons.context(rel.getCluster());
    }

    public static BaseQueryContext context(RelOptCluster cluster) {
        return Objects.requireNonNull((BaseQueryContext)cluster.getPlanner().getContext().unwrap(BaseQueryContext.class));
    }

    public static PlanningContext context(Context ctx) {
        return Objects.requireNonNull((PlanningContext)ctx.unwrap(PlanningContext.class));
    }

    public static Map<String, Object> parametersMap(@Nullable Object[] params) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        return params != null ? Commons.populateParameters(res, params) : res;
    }

    public static Map<String, Object> populateParameters(@NotNull Map<String, Object> dst, @Nullable Object[] params) {
        if (!ArrayUtils.nullOrEmpty((Object[])params)) {
            for (int i = 0; i < params.length; ++i) {
                dst.put("?" + i, params[i]);
            }
        }
        return dst;
    }

    public static void close(Object o) throws Exception {
        if (o instanceof AutoCloseable) {
            ((AutoCloseable)o).close();
        }
    }

    public static void close(Object o, @NotNull IgniteLogger log) {
        if (o instanceof AutoCloseable) {
            try {
                ((AutoCloseable)o).close();
            }
            catch (Exception e) {
                log.warn("Failed to close resource: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static <T> List<T> flat(List<List<? extends T>> src) {
        return src.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static int max(ImmutableIntList list) {
        if (list.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        int res = list.getInt(0);
        for (int i = 1; i < list.size(); ++i) {
            res = Math.max(res, list.getInt(i));
        }
        return res;
    }

    public static int min(ImmutableIntList list) {
        if (list.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        int res = list.getInt(0);
        for (int i = 1; i < list.size(); ++i) {
            res = Math.min(res, list.getInt(i));
        }
        return res;
    }

    public static <T> T compile(Class<T> interfaceType, String body) {
        boolean debug = (Boolean)CalciteSystemProperty.DEBUG.value();
        if (debug) {
            Util.debugCode((PrintStream)System.out, (String)body);
        }
        try {
            ICompilerFactory compilerFactory;
            try {
                compilerFactory = CompilerFactoryFactory.getDefaultCompilerFactory();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to instantiate java compiler", e);
            }
            IClassBodyEvaluator cbe = compilerFactory.newClassBodyEvaluator();
            cbe.setImplementedInterfaces(new Class[]{interfaceType});
            cbe.setParentClassLoader(ExpressionFactoryImpl.class.getClassLoader());
            if (debug) {
                cbe.setDebuggingInformation(true, true, true);
            }
            return (T)cbe.createInstance((Reader)new StringReader(body));
        }
        catch (Exception e) {
            throw new IgniteException((Throwable)e);
        }
    }

    public static void checkRange(@NotNull Object[] array, int idx) {
        if (idx < 0 || idx >= array.length) {
            throw new ArrayIndexOutOfBoundsException(idx);
        }
    }

    public static <T> T[] ensureCapacity(T[] array, int required) {
        if (required < 0) {
            throw new IllegalArgumentException("Capacity must not be negative");
        }
        return array.length <= required ? Arrays.copyOf(array, Commons.nextPowerOf2(required)) : array;
    }

    public static int nextPowerOf2(int v) {
        if (v < 0) {
            throw new IllegalArgumentException("v must not be negative");
        }
        if (v == 0) {
            return 1;
        }
        return 1 << 32 - Integer.numberOfLeadingZeros(v - 1);
    }

    public static <T> Predicate<T> negate(Predicate<T> p) {
        return p.negate();
    }

    public static Mappings.TargetMapping mapping(ImmutableBitSet bitSet, int sourceSize) {
        Mapping mapping = Mappings.create((MappingType)MappingType.PARTIAL_FUNCTION, (int)sourceSize, (int)bitSet.cardinality());
        for (Ord ord : Ord.zip((Iterable)bitSet)) {
            mapping.set(((Integer)ord.e).intValue(), ord.i);
        }
        return mapping;
    }

    public static Mappings.TargetMapping inverseMapping(ImmutableBitSet bitSet, int sourceSize) {
        Mapping mapping = Mappings.create((MappingType)MappingType.INVERSE_FUNCTION, (int)sourceSize, (int)bitSet.cardinality());
        for (Ord ord : Ord.zip((Iterable)bitSet)) {
            mapping.set(((Integer)ord.e).intValue(), ord.i);
        }
        return mapping;
    }

    public static <T> boolean isPrefix(List<T> seq, Collection<T> elems) {
        HashSet<T> elems0 = new HashSet<T>(elems);
        if (seq.size() < elems0.size()) {
            return false;
        }
        for (T e : seq) {
            if (!elems0.remove(e)) {
                return false;
            }
            if (!elems0.isEmpty()) continue;
            break;
        }
        return true;
    }

    public static IntList maxPrefix(ImmutableIntList seq, Collection<Integer> elems) {
        int e;
        IntArrayList res = new IntArrayList();
        IntOpenHashSet elems0 = new IntOpenHashSet(elems);
        for (int i = 0; i < seq.size() && elems0.remove(e = seq.getInt(i)); ++i) {
            res.add(e);
        }
        return res;
    }

    public static void closeQuiet(@Nullable Object obj) {
        if (obj instanceof AutoCloseable) {
            try {
                ((AutoCloseable)obj).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Class<?> nativeTypeToClass(NativeType type) {
        assert (type != null);
        switch (type.spec()) {
            case INT8: {
                return Byte.class;
            }
            case INT16: {
                return Short.class;
            }
            case INT32: {
                return Integer.class;
            }
            case INT64: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case NUMBER: {
                return BigInteger.class;
            }
            case DECIMAL: {
                return BigDecimal.class;
            }
            case UUID: {
                return UUID.class;
            }
            case STRING: {
                return String.class;
            }
            case BYTES: {
                return byte[].class;
            }
            case BITMASK: {
                return BitSet.class;
            }
            case DATE: {
                return LocalDate.class;
            }
            case TIME: {
                return LocalTime.class;
            }
            case DATETIME: {
                return LocalDateTime.class;
            }
            case TIMESTAMP: {
                return Instant.class;
            }
        }
        throw new IllegalArgumentException("Unsupported type " + type.spec());
    }

    public static int nativeTypePrecision(NativeType type) {
        assert (type != null);
        switch (type.spec()) {
            case INT8: {
                return 3;
            }
            case INT16: {
                return 5;
            }
            case INT32: {
                return 10;
            }
            case INT64: {
                return 19;
            }
            case FLOAT: 
            case DOUBLE: {
                return 15;
            }
            case NUMBER: {
                return ((NumberNativeType)type).precision();
            }
            case DECIMAL: {
                return ((DecimalNativeType)type).precision();
            }
            case UUID: 
            case DATE: {
                return -1;
            }
            case TIME: 
            case DATETIME: 
            case TIMESTAMP: {
                return ((TemporalNativeType)type).precision();
            }
            case STRING: 
            case BYTES: {
                return ((VarlenNativeType)type).length();
            }
            case BITMASK: {
                return ((BitmaskNativeType)type).bits();
            }
        }
        throw new IllegalArgumentException("Unsupported type " + type.spec());
    }

    public static int nativeTypeScale(NativeType type) {
        switch (type.spec()) {
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: 
            case NUMBER: {
                return 0;
            }
            case FLOAT: 
            case DOUBLE: 
            case UUID: 
            case STRING: 
            case BYTES: 
            case BITMASK: 
            case DATE: 
            case TIME: 
            case DATETIME: 
            case TIMESTAMP: {
                return Integer.MIN_VALUE;
            }
            case DECIMAL: {
                return ((DecimalNativeType)type).scale();
            }
        }
        throw new IllegalArgumentException("Unsupported type " + type.spec());
    }

    public static <T> Comparator<T> compoundComparator(Iterable<Comparator<T>> cmps) {
        return (r1, r2) -> {
            for (Comparator cmp : cmps) {
                int result = cmp.compare(r1, r2);
                if (result == 0) continue;
                return result;
            }
            return 0;
        };
    }

    public static SqlNodeList parse(String qry, SqlParser.Config parserCfg) {
        try {
            return Commons.parse((Reader)new SourceStringReader(qry), parserCfg);
        }
        catch (SqlParseException e) {
            throw new IgniteInternalException("Failed to parse query", (Throwable)e);
        }
    }

    public static SqlNodeList parse(Reader reader, SqlParser.Config parserCfg) throws SqlParseException {
        SqlParser parser = SqlParser.create((Reader)reader, (SqlParser.Config)parserCfg);
        return parser.parseStmtList();
    }

    public static RelOptCluster cluster() {
        return BaseQueryContext.CLUSTER;
    }

    public static RelOptCluster createCluster() {
        return BaseQueryContext.createCluster();
    }
}

