/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util;

import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.calcite.DataContext;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.ignite.internal.schema.NativeType;
import org.apache.ignite.internal.schema.NativeTypes;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeUtils {
    private static final EnumSet<SqlTypeName> CONVERTABLE_SQL_TYPES = EnumSet.of(SqlTypeName.DATE, SqlTypeName.TIME, SqlTypeName.TIMESTAMP);
    private static final Set<Type> CONVERTABLE_TYPES = Set.of(java.util.Date.class, Date.class, Time.class, Timestamp.class);

    public static RelDataType combinedRowType(IgniteTypeFactory typeFactory, RelDataType ... types) {
        RelDataTypeFactory.Builder builder = new RelDataTypeFactory.Builder((RelDataTypeFactory)typeFactory);
        HashSet<String> names = new HashSet<String>();
        for (RelDataType type : types) {
            for (RelDataTypeField field : type.getFieldList()) {
                int idx = 0;
                Object fieldName = field.getName();
                while (!names.add((String)fieldName)) {
                    fieldName = field.getName() + idx++;
                }
                builder.add((String)fieldName, field.getType());
            }
        }
        return builder.build();
    }

    public static boolean needCast(RelDataTypeFactory factory, RelDataType fromType, RelDataType toType) {
        if (fromType instanceof RelDataTypeFactoryImpl.JavaType && toType.getSqlTypeName() == fromType.getSqlTypeName()) {
            return false;
        }
        if (toType.getSqlTypeName() == SqlTypeName.ANY || fromType.getSqlTypeName() == SqlTypeName.ANY) {
            return false;
        }
        if (SqlTypeUtil.isCharacter((RelDataType)toType) && SqlTypeUtil.isCharacter((RelDataType)fromType)) {
            return false;
        }
        if (fromType.getPrecedenceList().containsType(toType) && SqlTypeUtil.isIntType((RelDataType)fromType) && SqlTypeUtil.isIntType((RelDataType)toType)) {
            return false;
        }
        if (SqlTypeUtil.equalSansNullability((RelDataTypeFactory)factory, (RelDataType)fromType, (RelDataType)toType)) {
            return false;
        }
        assert (SqlTypeUtil.canCastFrom((RelDataType)toType, (RelDataType)fromType, (boolean)true));
        return true;
    }

    @NotNull
    public static RelDataType createRowType(@NotNull IgniteTypeFactory typeFactory, Class<?> ... fields) {
        List<RelDataType> types = Arrays.stream(fields).map(arg_0 -> ((IgniteTypeFactory)typeFactory).createJavaType(arg_0)).collect(Collectors.toList());
        return TypeUtils.createRowType(typeFactory, types, "$F");
    }

    @NotNull
    public static RelDataType createRowType(@NotNull IgniteTypeFactory typeFactory, RelDataType ... fields) {
        List<RelDataType> types = Arrays.asList(fields);
        return TypeUtils.createRowType(typeFactory, types, "$F");
    }

    private static RelDataType createRowType(IgniteTypeFactory typeFactory, List<RelDataType> fields, String namePreffix) {
        List names = IntStream.range(0, fields.size()).mapToObj(ord -> namePreffix + ord).collect(Collectors.toList());
        return typeFactory.createStructType(fields, names);
    }

    public static RelDataType sqlType(IgniteTypeFactory typeFactory, RelDataType rowType) {
        if (!rowType.isStruct()) {
            return typeFactory.toSql(rowType);
        }
        return typeFactory.createStructType(Commons.transform(rowType.getFieldList(), f -> Pair.of((Object)f.getName(), (Object)TypeUtils.sqlType(typeFactory, f.getType()))));
    }

    public static RelDataType getResultType(IgniteTypeFactory typeFactory, RelOptSchema schema, RelDataType sqlType, @Nullable List<List<String>> origins) {
        assert (origins == null || origins.size() == sqlType.getFieldCount());
        RelDataTypeFactory.Builder b = new RelDataTypeFactory.Builder((RelDataTypeFactory)typeFactory);
        List fields = sqlType.getFieldList();
        for (int i = 0; i < sqlType.getFieldCount(); ++i) {
            List<String> origin = origins == null ? null : origins.get(i);
            b.add(((RelDataTypeField)fields.get(i)).getName(), typeFactory.createType(TypeUtils.getResultClass(typeFactory, schema, ((RelDataTypeField)fields.get(i)).getType(), origin)));
        }
        return b.build();
    }

    private static Type getResultClass(IgniteTypeFactory typeFactory, RelOptSchema schema, RelDataType type, @Nullable List<String> origin) {
        if (CollectionUtils.nullOrEmpty(origin)) {
            return typeFactory.getResultClass(type);
        }
        RelOptTable table = schema.getTableForMember(origin.subList(0, origin.size() - 1));
        assert (table != null);
        ColumnDescriptor fldDesc = ((TableDescriptor)table.unwrap(TableDescriptor.class)).columnDescriptor((String)Util.last(origin));
        assert (fldDesc != null);
        return Commons.nativeTypeToClass(fldDesc.storageType());
    }

    public static <RowT> Function<RowT, RowT> resultTypeConverter(ExecutionContext<RowT> ectx, RelDataType resultType) {
        assert (resultType.isStruct());
        if (TypeUtils.hasConvertableFields(resultType)) {
            RowHandler handler = ectx.rowHandler();
            List types = RelOptUtil.getFieldTypeList((RelDataType)resultType);
            RowHandler.RowFactory factory = handler.factory(ectx.getTypeFactory(), types);
            List<Function> converters = Commons.transform(types, t -> TypeUtils.fieldConverter(ectx, t));
            return r -> {
                Object newRow = factory.create();
                assert (handler.columnCount(newRow) == converters.size());
                assert (handler.columnCount(r) == converters.size());
                for (int i = 0; i < converters.size(); ++i) {
                    handler.set(i, newRow, ((Function)converters.get(i)).apply(handler.get(i, r)));
                }
                return newRow;
            };
        }
        return Function.identity();
    }

    private static Function<Object, Object> fieldConverter(ExecutionContext<?> ectx, RelDataType fieldType) {
        if (CONVERTABLE_SQL_TYPES.contains(fieldType.getSqlTypeName())) {
            Type storageType = ectx.getTypeFactory().getJavaClass(fieldType);
            return v -> TypeUtils.fromInternal(ectx, v, storageType);
        }
        return Function.identity();
    }

    public static boolean isConvertableType(Type type) {
        return CONVERTABLE_TYPES.contains(type);
    }

    public static boolean isConvertableType(RelDataType type) {
        return CONVERTABLE_SQL_TYPES.contains(type.getSqlTypeName());
    }

    private static boolean hasConvertableFields(RelDataType resultType) {
        return RelOptUtil.getFieldTypeList((RelDataType)resultType).stream().anyMatch(t -> CONVERTABLE_SQL_TYPES.contains(t.getSqlTypeName()));
    }

    public static Object toInternal(ExecutionContext<?> ectx, Object val) {
        return val == null ? null : TypeUtils.toInternal(ectx, val, val.getClass());
    }

    public static Object toInternal(ExecutionContext<?> ectx, Object val, Type storageType) {
        if (val == null) {
            return null;
        }
        if (storageType == Date.class) {
            return (int)(SqlFunctions.toLong((java.util.Date)((java.util.Date)val), (TimeZone)((TimeZone)DataContext.Variable.TIME_ZONE.get(ectx))) / 86400000L);
        }
        if (storageType == Time.class) {
            return (int)(SqlFunctions.toLong((java.util.Date)((java.util.Date)val), (TimeZone)((TimeZone)DataContext.Variable.TIME_ZONE.get(ectx))) % 86400000L);
        }
        if (storageType == Timestamp.class) {
            return SqlFunctions.toLong((java.util.Date)((java.util.Date)val), (TimeZone)((TimeZone)DataContext.Variable.TIME_ZONE.get(ectx)));
        }
        if (storageType == java.util.Date.class) {
            return SqlFunctions.toLong((java.util.Date)((java.util.Date)val), (TimeZone)((TimeZone)DataContext.Variable.TIME_ZONE.get(ectx)));
        }
        return val;
    }

    public static Object fromInternal(ExecutionContext<?> ectx, Object val, Type storageType) {
        if (val == null) {
            return null;
        }
        if (storageType == Date.class && val instanceof Integer) {
            long t = (long)((Integer)val).intValue() * 86400000L;
            return new Date(t - (long)((TimeZone)DataContext.Variable.TIME_ZONE.get(ectx)).getOffset(t));
        }
        if (storageType == Time.class && val instanceof Integer) {
            return new Time((Integer)val - ((TimeZone)DataContext.Variable.TIME_ZONE.get(ectx)).getOffset(((Integer)val).intValue()));
        }
        if (storageType == Timestamp.class && val instanceof Long) {
            return new Timestamp((Long)val - (long)((TimeZone)DataContext.Variable.TIME_ZONE.get(ectx)).getOffset((Long)val));
        }
        if (storageType == java.util.Date.class && val instanceof Long) {
            return new java.util.Date((Long)val - (long)((TimeZone)DataContext.Variable.TIME_ZONE.get(ectx)).getOffset((Long)val));
        }
        return val;
    }

    public static NativeType nativeType(RelDataType type) {
        switch (type.getSqlTypeName()) {
            case VARCHAR: 
            case CHAR: {
                return type.getPrecision() > 0 ? NativeTypes.stringOf((int)type.getPrecision()) : NativeTypes.STRING;
            }
            case DATE: {
                return NativeTypes.DATE;
            }
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: {
                return type.getPrecision() > 0 ? NativeTypes.time((int)type.getPrecision()) : NativeTypes.time();
            }
            case INTEGER: {
                return NativeTypes.INT32;
            }
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return type.getPrecision() > 0 ? NativeTypes.timestamp((int)type.getPrecision()) : NativeTypes.timestamp();
            }
            case BIGINT: {
                return NativeTypes.INT64;
            }
            case SMALLINT: {
                return NativeTypes.INT16;
            }
            case TINYINT: {
                return NativeTypes.INT8;
            }
            case DECIMAL: {
                return NativeTypes.decimalOf((int)type.getPrecision(), (int)type.getScale());
            }
            case BOOLEAN: {
                return NativeTypes.INT8;
            }
            case DOUBLE: {
                return NativeTypes.DOUBLE;
            }
            case REAL: 
            case FLOAT: {
                return NativeTypes.FLOAT;
            }
            case BINARY: 
            case VARBINARY: {
                return NativeTypes.blobOf((int)type.getPrecision());
            }
            case ANY: 
            case OTHER: {
                return NativeTypes.blobOf((int)type.getPrecision());
            }
        }
        assert (false) : "Unexpected type of result: " + type;
        return null;
    }
}

