/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.hadoop.fileSystem;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.fileSystem.FSType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HDFSConfUtil {
    private static TSFileConfig tsFileConfig = TSFileDescriptor.getInstance().getConfig();
    private static final Logger logger = LoggerFactory.getLogger(HDFSConfUtil.class);

    HDFSConfUtil() {
    }

    static Configuration setConf(Configuration conf) {
        if (!tsFileConfig.getTSFileStorageFs().equals((Object)FSType.HDFS)) {
            return conf;
        }
        try {
            conf.addResource(new File(tsFileConfig.getCoreSitePath()).toURI().toURL());
            conf.addResource(new File(tsFileConfig.getHdfsSitePath()).toURI().toURL());
        }
        catch (MalformedURLException e) {
            logger.error("Failed to add resource core-site.xml {} and hdfs-site.xml {}. ", new Object[]{tsFileConfig.getCoreSitePath(), tsFileConfig.getHdfsSitePath(), e});
        }
        conf.set("fs.hdfs.impl", "org.apache.hadoop.hdfs.DistributedFileSystem");
        conf.set("dfs.client.block.write.replace-datanode-on-failure.policy", "NEVER");
        conf.set("dfs.client.block.write.replace-datanode-on-failure.enable", "true");
        String[] hdfsIps = tsFileConfig.getHdfsIp();
        if (hdfsIps.length > 1) {
            String dfsNameservices = tsFileConfig.getDfsNameServices();
            CharSequence[] dfsHaNamenodes = tsFileConfig.getDfsHaNamenodes();
            conf.set("dfs.nameservices", dfsNameservices);
            conf.set("dfs.ha.namenodes." + dfsNameservices, String.join((CharSequence)",", dfsHaNamenodes));
            for (int i = 0; i < dfsHaNamenodes.length; ++i) {
                conf.set("dfs.namenode.rpc-address." + dfsNameservices + "." + ((String)dfsHaNamenodes[i]).trim(), hdfsIps[i] + ":" + tsFileConfig.getHdfsPort());
            }
            boolean dfsHaAutomaticFailoverEnabled = tsFileConfig.isDfsHaAutomaticFailoverEnabled();
            conf.set("dfs.ha.automatic-failover.enabled", String.valueOf(dfsHaAutomaticFailoverEnabled));
            if (dfsHaAutomaticFailoverEnabled) {
                conf.set("dfs.client.failover.proxy.provider." + dfsNameservices, tsFileConfig.getDfsClientFailoverProxyProvider());
            }
        }
        if (tsFileConfig.isUseKerberos()) {
            conf.set("hadoop.security.authorization", "true");
            conf.set("hadoop.security.authentication", "kerberos");
            conf.set("dfs.block.access.token.enable", "true");
            UserGroupInformation.setConfiguration((Configuration)conf);
            try {
                UserGroupInformation.loginUserFromKeytab((String)tsFileConfig.getKerberosPrincipal(), (String)tsFileConfig.getKerberosKeytabFilePath());
            }
            catch (IOException e) {
                logger.error("Failed to login user from key tab. User: {}, path:{}. ", new Object[]{tsFileConfig.getKerberosPrincipal(), tsFileConfig.getKerberosKeytabFilePath(), e});
            }
        }
        return conf;
    }
}

