/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.hadoop.fileSystem;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.iotdb.hadoop.fileSystem.HDFSConfUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSFile
extends File {
    private static final long serialVersionUID = -8419827359081949547L;
    private Path hdfsPath;
    private FileSystem fs;
    private static final Logger logger = LoggerFactory.getLogger(HDFSFile.class);
    private static final String UNSUPPORT_OPERATION = "Unsupported operation.";

    public HDFSFile(String pathname) {
        super(pathname);
        this.hdfsPath = new Path(pathname);
        this.setConfAndGetFS();
    }

    public HDFSFile(String parent, String child) {
        super(parent, child);
        this.hdfsPath = new Path(parent + File.separator + child);
        this.setConfAndGetFS();
    }

    public HDFSFile(File parent, String child) {
        super(parent, child);
        this.hdfsPath = new Path(parent.getAbsolutePath() + File.separator + child);
        this.setConfAndGetFS();
    }

    public HDFSFile(URI uri) {
        super(uri);
        this.hdfsPath = new Path(uri);
        this.setConfAndGetFS();
    }

    private void setConfAndGetFS() {
        Configuration conf = HDFSConfUtil.setConf(new Configuration());
        try {
            this.fs = this.hdfsPath.getFileSystem(conf);
        }
        catch (IOException e) {
            logger.error("Fail to get HDFS! ", (Throwable)e);
        }
    }

    @Override
    public String getAbsolutePath() {
        return this.hdfsPath.toUri().toString();
    }

    @Override
    public String getPath() {
        return this.hdfsPath.toUri().toString();
    }

    @Override
    public long length() {
        try {
            return this.fs.getFileStatus(this.hdfsPath).getLen();
        }
        catch (IOException e) {
            logger.error("Fail to get length of the file {}, ", (Object)this.hdfsPath.toUri(), (Object)e);
            return 0L;
        }
    }

    @Override
    public boolean exists() {
        try {
            return this.fs.exists(this.hdfsPath);
        }
        catch (IOException e) {
            logger.error("Fail to check whether the file {} exists. ", (Object)this.hdfsPath.toUri(), (Object)e);
            return false;
        }
    }

    @Override
    public File[] listFiles() {
        ArrayList<HDFSFile> files = new ArrayList<HDFSFile>();
        try {
            for (FileStatus fileStatus : this.fs.listStatus(this.hdfsPath)) {
                Path filePath = fileStatus.getPath();
                files.add(new HDFSFile(filePath.toUri().toString()));
            }
            return files.toArray(new HDFSFile[0]);
        }
        catch (IOException e) {
            logger.error("Fail to list files in {}. ", (Object)this.hdfsPath.toUri(), (Object)e);
            return null;
        }
    }

    @Override
    public File getParentFile() {
        return new HDFSFile(this.hdfsPath.getParent().toUri().toString());
    }

    @Override
    public boolean createNewFile() throws IOException {
        return this.fs.createNewFile(this.hdfsPath);
    }

    @Override
    public boolean delete() {
        try {
            return !this.fs.exists(this.hdfsPath) || this.fs.delete(this.hdfsPath, true);
        }
        catch (IOException e) {
            logger.error("Fail to delete file {}. ", (Object)this.hdfsPath.toUri(), (Object)e);
            return false;
        }
    }

    @Override
    public boolean mkdirs() {
        try {
            return !this.exists() && this.fs.mkdirs(this.hdfsPath);
        }
        catch (IOException e) {
            logger.error("Fail to create directory {}. ", (Object)this.hdfsPath.toUri(), (Object)e);
            return false;
        }
    }

    @Override
    public boolean isDirectory() {
        try {
            return this.exists() && this.fs.getFileStatus(this.hdfsPath).isDirectory();
        }
        catch (IOException e) {
            logger.error("Fail to judge whether {} is a directory. ", (Object)this.hdfsPath.toUri(), (Object)e);
            return false;
        }
    }

    @Override
    public long getFreeSpace() {
        try {
            return this.fs.getStatus().getRemaining();
        }
        catch (IOException e) {
            logger.error("Fail to get free space of {}. ", (Object)this.hdfsPath.toUri(), (Object)e);
            return 0L;
        }
    }

    @Override
    public String getName() {
        return this.hdfsPath.getName();
    }

    @Override
    public String toString() {
        return this.hdfsPath.toUri().toString();
    }

    @Override
    public int hashCode() {
        return this.hdfsPath.hashCode();
    }

    @Override
    public int compareTo(File pathname) {
        if (pathname instanceof HDFSFile) {
            return this.hdfsPath.toUri().toString().compareTo(pathname.getPath());
        }
        logger.error("File {} is not HDFS file. ", (Object)pathname.getPath());
        throw new IllegalArgumentException("Compare file is not HDFS file.");
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof HDFSFile && this.compareTo((HDFSFile)obj) == 0;
    }

    @Override
    public boolean renameTo(File dest) {
        try {
            return this.fs.rename(this.hdfsPath, new Path(dest.getAbsolutePath()));
        }
        catch (IOException e) {
            logger.error("Failed to rename file {} to {}. ", new Object[]{this.hdfsPath, dest.getName(), e});
            return false;
        }
    }

    public BufferedReader getBufferedReader(String filePath) {
        try {
            return new BufferedReader(new InputStreamReader((InputStream)this.fs.open(new Path(filePath))));
        }
        catch (IOException e) {
            logger.error("Failed to get buffered reader for {}. ", (Object)filePath, (Object)e);
            return null;
        }
    }

    public BufferedWriter getBufferedWriter(String filePath, boolean append) {
        try {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)this.fs.create(new Path(filePath))));
        }
        catch (IOException e) {
            logger.error("Failed to get buffered writer for {}. ", (Object)filePath, (Object)e);
            return null;
        }
    }

    public BufferedInputStream getBufferedInputStream(String filePath) {
        try {
            return new BufferedInputStream((InputStream)this.fs.open(new Path(filePath)));
        }
        catch (IOException e) {
            logger.error("Failed to get buffered input stream for {}. ", (Object)filePath, (Object)e);
            return null;
        }
    }

    public BufferedOutputStream getBufferedOutputStream(String filePath) {
        try {
            return new BufferedOutputStream((OutputStream)this.fs.create(new Path(filePath)));
        }
        catch (IOException e) {
            logger.error("Failed to get buffered output stream for {}. ", (Object)filePath, (Object)e);
            return null;
        }
    }

    public File[] listFilesBySuffix(String fileFolder, String suffix) {
        PathFilter pathFilter = path -> path.toUri().toString().endsWith(suffix);
        List<HDFSFile> files = this.listFiles(fileFolder, pathFilter);
        return files.toArray(new HDFSFile[0]);
    }

    public File[] listFilesByPrefix(String fileFolder, String prefix) {
        PathFilter pathFilter = path -> path.toUri().toString().startsWith(prefix);
        List<HDFSFile> files = this.listFiles(fileFolder, pathFilter);
        return files.toArray(new HDFSFile[0]);
    }

    private List<HDFSFile> listFiles(String fileFolder, PathFilter pathFilter) {
        ArrayList<HDFSFile> files = new ArrayList<HDFSFile>();
        try {
            Path path = new Path(fileFolder);
            for (FileStatus fileStatus : this.fs.listStatus(path)) {
                Path filePath = fileStatus.getPath();
                if (!pathFilter.accept(filePath)) continue;
                HDFSFile file = new HDFSFile(filePath.toUri().toString());
                files.add(file);
            }
        }
        catch (IOException e) {
            logger.error("Failed to list files in {}. ", (Object)fileFolder);
        }
        return files;
    }

    @Override
    public File getAbsoluteFile() {
        return new HDFSFile(this.getAbsolutePath());
    }

    @Override
    public String getParent() {
        throw new UnsupportedOperationException(UNSUPPORT_OPERATION);
    }

    @Override
    public boolean isAbsolute() {
        throw new UnsupportedOperationException(UNSUPPORT_OPERATION);
    }

    @Override
    public File[] listFiles(FileFilter filter) {
        throw new UnsupportedOperationException(UNSUPPORT_OPERATION);
    }

    @Override
    public String getCanonicalPath() {
        throw new UnsupportedOperationException(UNSUPPORT_OPERATION);
    }

    @Override
    public File getCanonicalFile() {
        throw new UnsupportedOperationException(UNSUPPORT_OPERATION);
    }

    @Override
    public URL toURL() {
        throw new UnsupportedOperationException(UNSUPPORT_OPERATION);
    }

    @Override
    public URI toURI() {
        throw new UnsupportedOperationException(UNSUPPORT_OPERATION);
    }

    @Override
    public boolean canRead() {
        throw new UnsupportedOperationException(UNSUPPORT_OPERATION);
    }

    @Override
    public boolean canWrite() {
        throw new UnsupportedOperationException(UNSUPPORT_OPERATION);
    }

    @Override
    public boolean isFile() {
        throw new UnsupportedOperationException(UNSUPPORT_OPERATION);
    }

    @Override
    public boolean isHidden() {
        throw new UnsupportedOperationException(UNSUPPORT_OPERATION);
    }

    @Override
    public long lastModified() {
        throw new UnsupportedOperationException(UNSUPPORT_OPERATION);
    }

    @Override
    public void deleteOnExit() {
        throw new UnsupportedOperationException(UNSUPPORT_OPERATION);
    }

    @Override
    public String[] list() {
        throw new UnsupportedOperationException(UNSUPPORT_OPERATION);
    }

    @Override
    public String[] list(FilenameFilter filter) {
        throw new UnsupportedOperationException(UNSUPPORT_OPERATION);
    }

    @Override
    public File[] listFiles(FilenameFilter filter) {
        throw new UnsupportedOperationException(UNSUPPORT_OPERATION);
    }

    @Override
    public boolean mkdir() {
        throw new UnsupportedOperationException(UNSUPPORT_OPERATION);
    }

    @Override
    public boolean setLastModified(long time) {
        throw new UnsupportedOperationException(UNSUPPORT_OPERATION);
    }

    @Override
    public boolean setReadOnly() {
        throw new UnsupportedOperationException(UNSUPPORT_OPERATION);
    }

    @Override
    public boolean setWritable(boolean writable, boolean ownerOnly) {
        throw new UnsupportedOperationException(UNSUPPORT_OPERATION);
    }

    @Override
    public boolean setWritable(boolean writable) {
        throw new UnsupportedOperationException(UNSUPPORT_OPERATION);
    }

    @Override
    public boolean setReadable(boolean readable, boolean ownerOnly) {
        throw new UnsupportedOperationException(UNSUPPORT_OPERATION);
    }

    @Override
    public boolean setReadable(boolean readable) {
        throw new UnsupportedOperationException(UNSUPPORT_OPERATION);
    }

    @Override
    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        throw new UnsupportedOperationException(UNSUPPORT_OPERATION);
    }

    @Override
    public boolean setExecutable(boolean executable) {
        throw new UnsupportedOperationException(UNSUPPORT_OPERATION);
    }

    @Override
    public boolean canExecute() {
        throw new UnsupportedOperationException(UNSUPPORT_OPERATION);
    }

    @Override
    public long getTotalSpace() {
        throw new UnsupportedOperationException(UNSUPPORT_OPERATION);
    }

    @Override
    public long getUsableSpace() {
        throw new UnsupportedOperationException(UNSUPPORT_OPERATION);
    }

    @Override
    public java.nio.file.Path toPath() {
        throw new UnsupportedOperationException(UNSUPPORT_OPERATION);
    }
}

