/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.hadoop.fileSystem;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumFileSystem;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iotdb.tsfile.read.reader.TsFileInput;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class HDFSInput
implements TsFileInput {
    private FSDataInputStream fsDataInputStream;
    private FileSystem fs;
    private Path path;

    public HDFSInput(String filePath) throws IOException {
        this(new Path(filePath), new Configuration());
    }

    public HDFSInput(String filePath, Configuration configuration) throws IOException {
        this(new Path(filePath), configuration);
    }

    public HDFSInput(Path path, Configuration configuration) throws IOException {
        this.fs = path.getFileSystem(configuration);
        this.path = path;
        this.fsDataInputStream = this.fs.open(path);
    }

    public long size() throws IOException {
        return this.fs.getFileStatus(this.path).getLen();
    }

    public long position() throws IOException {
        return this.fsDataInputStream.getPos();
    }

    public synchronized TsFileInput position(long newPosition) throws IOException {
        this.fsDataInputStream.seek(newPosition);
        return this;
    }

    public synchronized int read(ByteBuffer dst) throws IOException {
        int res;
        if (this.fs instanceof ChecksumFileSystem) {
            byte[] bytes = new byte[dst.remaining()];
            res = this.fsDataInputStream.read(bytes);
            dst.put(bytes);
        } else {
            res = this.fsDataInputStream.read(dst);
        }
        return res;
    }

    public synchronized int read(ByteBuffer dst, long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("position must be non-negative");
        }
        if (position >= this.size()) {
            return -1;
        }
        long srcPosition = this.fsDataInputStream.getPos();
        this.fsDataInputStream.seek(position);
        int res = this.read(dst);
        this.fsDataInputStream.seek(srcPosition);
        return res;
    }

    public int read() {
        throw new UnsupportedOperationException();
    }

    public int read(byte[] b, int off, int len) {
        throw new UnsupportedOperationException();
    }

    public FileChannel wrapAsFileChannel() {
        throw new UnsupportedOperationException();
    }

    public InputStream wrapAsInputStream() {
        return this.fsDataInputStream;
    }

    public void close() throws IOException {
        this.fsDataInputStream.close();
    }

    public int readInt() {
        throw new UnsupportedOperationException();
    }

    public synchronized String readVarIntString(long position) throws IOException {
        long srcPosition = this.fsDataInputStream.getPos();
        this.fsDataInputStream.seek(position);
        String res = ReadWriteIOUtils.readVarIntString((InputStream)this.fsDataInputStream);
        this.fsDataInputStream.seek(srcPosition);
        return res;
    }

    public String getFilePath() {
        return this.path.toString();
    }
}

