/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.hadoop.fileSystem;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iotdb.hadoop.fileSystem.HDFSConfUtil;
import org.apache.iotdb.tsfile.write.writer.TsFileOutput;

public class HDFSOutput
implements TsFileOutput {
    private FSDataOutputStream fsDataOutputStream;
    private FileSystem fs;
    private Path path;

    public HDFSOutput(String filePath, boolean overwrite) throws IOException {
        this(filePath, new Configuration(), overwrite);
        this.path = new Path(filePath);
    }

    public HDFSOutput(String filePath, Configuration configuration, boolean overwrite) throws IOException {
        this(new Path(filePath), configuration, overwrite);
        this.path = new Path(filePath);
    }

    public HDFSOutput(Path path, Configuration configuration, boolean overwrite) throws IOException {
        this.fs = path.getFileSystem(HDFSConfUtil.setConf(configuration));
        this.fsDataOutputStream = this.fs.exists(path) ? this.fs.append(path) : this.fs.create(path, overwrite);
        this.path = path;
    }

    public void write(byte[] b) throws IOException {
        this.fsDataOutputStream.write(b);
    }

    public void write(byte b) throws IOException {
        this.fsDataOutputStream.write((int)b);
    }

    public void write(ByteBuffer b) {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    public long getPosition() throws IOException {
        return this.fsDataOutputStream.getPos();
    }

    public void close() throws IOException {
        this.fsDataOutputStream.close();
    }

    public OutputStream wrapAsStream() {
        return this.fsDataOutputStream;
    }

    public void flush() throws IOException {
        this.fsDataOutputStream.hflush();
    }

    public void truncate(long size) throws IOException {
        if (this.fs.exists(this.path)) {
            this.fsDataOutputStream.close();
        }
        this.fs.truncate(this.path, size);
        if (this.fs.exists(this.path)) {
            this.fsDataOutputStream = this.fs.append(this.path);
        }
    }
}

