/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.hadoop.tsfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.iotdb.hadoop.tsfile.TSFHadoopException;
import org.apache.iotdb.hadoop.tsfile.TSFInputSplit;
import org.apache.iotdb.hadoop.tsfile.TSFRecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSFInputFormat
extends FileInputFormat<NullWritable, MapWritable> {
    public static final String READ_TIME_ENABLE = "tsfile.read.time.enable";
    public static final String READ_DELTAOBJECT_ENABLE = "tsfile.read.deltaObjectId.enable";
    @Deprecated
    public static final String FILTER_TYPE = "tsfile.filter.type";
    @Deprecated
    public static final String FILTER_EXPRESSION = "tsfile.filter.expression";
    public static final String FILTER_EXIST = "tsfile.filter.exist";
    public static final String READ_DELTAOBJECTS = "tsfile.read.deltaobject";
    public static final String READ_MEASUREMENTID = "tsfile.read.measurement";
    private static final Logger logger = LoggerFactory.getLogger(TSFInputFormat.class);
    private static final String SEPARATOR = ",";

    public static void setReadDeviceIds(Job job, String[] value) throws TSFHadoopException {
        if (value == null || value.length < 1) {
            throw new TSFHadoopException("The devices selected is null or empty");
        }
        StringBuilder deltaObjectIdsBuilder = new StringBuilder();
        for (String deltaObjectId : value) {
            deltaObjectIdsBuilder.append(deltaObjectId).append(SEPARATOR);
        }
        String deltaObjectIds = deltaObjectIdsBuilder.toString();
        job.getConfiguration().set(READ_DELTAOBJECTS, (String)deltaObjectIds.subSequence(0, deltaObjectIds.length() - 1));
    }

    public static List<String> getReadDeviceIds(Configuration configuration) {
        String deviceIds = configuration.get(READ_DELTAOBJECTS);
        if (deviceIds == null || deviceIds.length() < 1) {
            return new LinkedList<String>();
        }
        return Arrays.stream(deviceIds.split(SEPARATOR)).collect(Collectors.toList());
    }

    public static void setReadMeasurementIds(Job job, String[] value) throws TSFHadoopException {
        if (value == null || value.length < 1) {
            throw new TSFHadoopException("The sensors selected is null or empty");
        }
        StringBuilder measurementIdsBuilder = new StringBuilder();
        for (String measurementId : value) {
            measurementIdsBuilder.append(measurementId).append(SEPARATOR);
        }
        String measurementIds = measurementIdsBuilder.toString();
        job.getConfiguration().set(READ_MEASUREMENTID, (String)measurementIds.subSequence(0, measurementIds.length() - 1));
    }

    public static List<String> getReadMeasurementIds(Configuration configuration) {
        String measurementIds = configuration.get(READ_MEASUREMENTID);
        if (measurementIds == null || measurementIds.length() < 1) {
            return new LinkedList<String>();
        }
        return Arrays.stream(measurementIds.split(SEPARATOR)).collect(Collectors.toList());
    }

    public static void setReadDeviceId(Job job, boolean value) {
        job.getConfiguration().setBoolean(READ_DELTAOBJECT_ENABLE, value);
    }

    public static boolean getReadDeviceId(Configuration configuration) {
        return configuration.getBoolean(READ_DELTAOBJECT_ENABLE, true);
    }

    public static void setReadTime(Job job, boolean value) {
        job.getConfiguration().setBoolean(READ_TIME_ENABLE, value);
    }

    public static boolean getReadTime(Configuration configuration) {
        return configuration.getBoolean(READ_TIME_ENABLE, true);
    }

    @Deprecated
    public static void setHasFilter(Job job, boolean value) {
        job.getConfiguration().setBoolean(FILTER_EXIST, value);
    }

    @Deprecated
    public static boolean getHasFilter(Configuration configuration) {
        return configuration.getBoolean(FILTER_EXIST, false);
    }

    @Deprecated
    public static void setFilterType(Job job, String value) {
        job.getConfiguration().set(FILTER_TYPE, value);
    }

    @Deprecated
    public static String getFilterType(Configuration configuration) {
        return configuration.get(FILTER_TYPE);
    }

    @Deprecated
    public static void setFilterExp(Job job, String value) {
        job.getConfiguration().set(FILTER_EXPRESSION, value);
    }

    @Deprecated
    public static String getFilterExp(Configuration configuration) {
        return configuration.get(FILTER_EXPRESSION);
    }

    public RecordReader<NullWritable, MapWritable> createRecordReader(InputSplit split, TaskAttemptContext context) {
        return new TSFRecordReader();
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        job.getConfiguration().setBoolean("mapreduce.input.fileinputformat.input.dir.recursive", true);
        List listFileStatus = super.listStatus(job);
        return new ArrayList<TSFInputSplit>(TSFInputFormat.getTSFInputSplit(job.getConfiguration(), listFileStatus, logger));
    }

    public static List<TSFInputSplit> getTSFInputSplit(Configuration configuration, List<FileStatus> listFileStatus, Logger logger) throws IOException {
        ArrayList<TSFInputSplit> splits = new ArrayList<TSFInputSplit>();
        logger.info("The number of this job file is {}", (Object)listFileStatus.size());
        for (FileStatus fileStatus : listFileStatus) {
            logger.info("The file path is {}", (Object)fileStatus.getPath());
            Path path = fileStatus.getPath();
            if (!path.toString().endsWith(".tsfile")) continue;
            long length = fileStatus.getLen();
            if (length > 0L) {
                FileSystem fileSystem = path.getFileSystem(configuration);
                logger.info("The file status is {}", (Object)fileStatus.getClass().getName());
                logger.info("The file system is " + fileSystem.getClass());
                Object[] blockLocations = fileSystem.getFileBlockLocations(fileStatus, 0L, length);
                logger.info("The block location information is {}", (Object)Arrays.toString(blockLocations));
                splits.addAll(TSFInputFormat.generateSplits(path, (BlockLocation[])blockLocations));
                continue;
            }
            logger.warn("The file length is " + length);
        }
        configuration.setLong("mapreduce.input.fileinputformat.numinputfiles", (long)listFileStatus.size());
        logger.info("The number of splits is " + splits.size());
        return splits;
    }

    private static List<TSFInputSplit> generateSplits(Path path, BlockLocation[] blockLocations) throws IOException {
        ArrayList<TSFInputSplit> splits = new ArrayList<TSFInputSplit>();
        for (BlockLocation blockLocation : blockLocations) {
            splits.add(new TSFInputSplit(path, blockLocation.getHosts(), blockLocation.getOffset(), blockLocation.getLength()));
        }
        return splits;
    }
}

