/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.hadoop.tsfile;

import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.iotdb.hadoop.tsfile.TSFRecordWriter;
import org.apache.iotdb.hadoop.tsfile.record.HDFSTSRecord;
import org.apache.iotdb.tsfile.write.schema.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSFOutputFormat
extends FileOutputFormat<NullWritable, HDFSTSRecord> {
    private static final Logger logger = LoggerFactory.getLogger(TSFOutputFormat.class);
    private static final String extension = "";
    private static Schema schema;

    public static Schema getSchema() {
        return schema;
    }

    public static void setSchema(Schema schema) {
        TSFOutputFormat.schema = schema;
    }

    public RecordWriter<NullWritable, HDFSTSRecord> getRecordWriter(TaskAttemptContext job) throws IOException {
        Path outputPath = this.getDefaultWorkFile(job, extension);
        logger.info("The task attempt id is {}, the output path is {}", (Object)job.getTaskAttemptID(), (Object)outputPath);
        return new TSFRecordWriter(job, outputPath, Objects.requireNonNull(schema));
    }
}

