/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.hadoop.tsfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.iotdb.hadoop.fileSystem.HDFSInput;
import org.apache.iotdb.hadoop.tsfile.IReaderSet;
import org.apache.iotdb.hadoop.tsfile.TSFInputFormat;
import org.apache.iotdb.hadoop.tsfile.TSFInputSplit;
import org.apache.iotdb.tsfile.read.TsFileReader;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.expression.QueryExpression;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.read.reader.TsFileInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSFRecordReader
extends RecordReader<NullWritable, MapWritable>
implements IReaderSet {
    private static final Logger logger = LoggerFactory.getLogger(TSFRecordReader.class);
    private List<QueryDataSet> dataSetList = new ArrayList<QueryDataSet>();
    private List<String> deviceIdList = new ArrayList<String>();
    private List<Field> fields = null;
    private int currentIndex = 0;
    private long timestamp = 0L;
    private boolean isReadDeviceId = false;
    private boolean isReadTime = false;
    private TsFileSequenceReader reader;
    private List<String> measurementIds;

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException {
        if (!(split instanceof TSFInputSplit)) {
            logger.error("The InputSplit class is not {}, the class is {}", (Object)TSFInputSplit.class.getName(), (Object)split.getClass().getName());
            throw new InternalError(String.format("The InputSplit class is not %s, the class is %s", TSFInputSplit.class.getName(), split.getClass().getName()));
        }
        TSFRecordReader.initialize((TSFInputSplit)split, context.getConfiguration(), this, this.dataSetList, this.deviceIdList);
    }

    public static void initialize(TSFInputSplit split, Configuration configuration, IReaderSet readerSet, List<QueryDataSet> dataSetList, List<String> deviceIdList) throws IOException {
        org.apache.hadoop.fs.Path path = split.getPath();
        TsFileSequenceReader reader = new TsFileSequenceReader((TsFileInput)new HDFSInput(path, configuration));
        readerSet.setReader(reader);
        List<String> deviceIds = TSFInputFormat.getReadDeviceIds(configuration);
        List<String> measurementIds = TSFInputFormat.getReadMeasurementIds(configuration);
        readerSet.setMeasurementIds(measurementIds);
        logger.info("deviceIds:" + deviceIds);
        logger.info("Sensors:" + measurementIds);
        readerSet.setReadDeviceId(TSFInputFormat.getReadDeviceId(configuration));
        readerSet.setReadTime(TSFInputFormat.getReadTime(configuration));
        try (TsFileReader queryEngine = new TsFileReader(reader);){
            for (String deviceId : deviceIds) {
                List paths = measurementIds.stream().map(measurementId -> new Path(deviceId, measurementId)).collect(Collectors.toList());
                QueryExpression queryExpression = QueryExpression.create(paths, null);
                QueryDataSet dataSet = queryEngine.query(queryExpression, split.getStart(), split.getStart() + split.getLength());
                dataSetList.add(dataSet);
                deviceIdList.add(deviceId);
            }
        }
    }

    public boolean nextKeyValue() throws IOException {
        while (this.currentIndex < this.dataSetList.size()) {
            if (!this.dataSetList.get(this.currentIndex).hasNext()) {
                ++this.currentIndex;
                continue;
            }
            RowRecord rowRecord = this.dataSetList.get(this.currentIndex).next();
            this.fields = rowRecord.getFields();
            this.timestamp = rowRecord.getTimestamp();
            return true;
        }
        return false;
    }

    public NullWritable getCurrentKey() {
        return NullWritable.get();
    }

    public MapWritable getCurrentValue() throws InterruptedException {
        return TSFRecordReader.getCurrentValue(this.deviceIdList, this.currentIndex, this.timestamp, this.isReadTime, this.isReadDeviceId, this.fields, this.measurementIds);
    }

    public static MapWritable getCurrentValue(List<String> deviceIdList, int currentIndex, long timestamp, boolean isReadTime, boolean isReadDeviceId, List<Field> fields, List<String> measurementIds) throws InterruptedException {
        MapWritable mapWritable = new MapWritable();
        Text deviceIdText = new Text(deviceIdList.get(currentIndex));
        LongWritable time = new LongWritable(timestamp);
        if (isReadTime) {
            mapWritable.put((Writable)new Text("time_stamp"), (Writable)time);
        }
        if (isReadDeviceId) {
            mapWritable.put((Writable)new Text("device_id"), (Writable)deviceIdText);
        }
        TSFRecordReader.readFieldsValue(mapWritable, fields, measurementIds);
        return mapWritable;
    }

    public static void readFieldsValue(MapWritable mapWritable, List<Field> fields, List<String> measurementIds) throws InterruptedException {
        int index = 0;
        for (Field field : fields) {
            if (field == null || field.getDataType() == null) {
                logger.info("Current value is null");
                mapWritable.put((Writable)new Text(measurementIds.get(index)), (Writable)NullWritable.get());
            } else {
                switch (field.getDataType()) {
                    case INT32: {
                        mapWritable.put((Writable)new Text(measurementIds.get(index)), (Writable)new IntWritable(field.getIntV()));
                        break;
                    }
                    case INT64: {
                        mapWritable.put((Writable)new Text(measurementIds.get(index)), (Writable)new LongWritable(field.getLongV()));
                        break;
                    }
                    case FLOAT: {
                        mapWritable.put((Writable)new Text(measurementIds.get(index)), (Writable)new FloatWritable(field.getFloatV()));
                        break;
                    }
                    case DOUBLE: {
                        mapWritable.put((Writable)new Text(measurementIds.get(index)), (Writable)new DoubleWritable(field.getDoubleV()));
                        break;
                    }
                    case BOOLEAN: {
                        mapWritable.put((Writable)new Text(measurementIds.get(index)), (Writable)new BooleanWritable(field.getBoolV()));
                        break;
                    }
                    case TEXT: {
                        mapWritable.put((Writable)new Text(measurementIds.get(index)), (Writable)new Text(field.getBinaryV().getStringValue()));
                        break;
                    }
                    default: {
                        logger.error("The data type is not support {}", (Object)field.getDataType());
                        throw new InterruptedException(String.format("The data type %s is not support ", field.getDataType()));
                    }
                }
            }
            ++index;
        }
    }

    public float getProgress() {
        return 0.0f;
    }

    public void close() throws IOException {
        this.dataSetList = null;
        this.deviceIdList = null;
        this.reader.close();
    }

    @Override
    public void setReader(TsFileSequenceReader reader) {
        this.reader = reader;
    }

    @Override
    public void setMeasurementIds(List<String> measurementIds) {
        this.measurementIds = measurementIds;
    }

    @Override
    public void setReadDeviceId(boolean isReadDeviceId) {
        this.isReadDeviceId = isReadDeviceId;
    }

    @Override
    public void setReadTime(boolean isReadTime) {
        this.isReadTime = isReadTime;
    }
}

