/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.hadoop.tsfile;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.iotdb.hadoop.fileSystem.HDFSOutput;
import org.apache.iotdb.hadoop.tsfile.record.HDFSTSRecord;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.schema.Schema;
import org.apache.iotdb.tsfile.write.writer.TsFileOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSFRecordWriter
extends RecordWriter<NullWritable, HDFSTSRecord> {
    private static final Logger logger = LoggerFactory.getLogger(TSFRecordWriter.class);
    private TsFileWriter writer;

    public TSFRecordWriter(TaskAttemptContext job, Path path, Schema schema) throws IOException {
        HDFSOutput hdfsOutput = new HDFSOutput(path.toString(), job.getConfiguration(), false);
        this.writer = new TsFileWriter((TsFileOutput)hdfsOutput, schema);
    }

    public synchronized void write(NullWritable key, HDFSTSRecord value) throws IOException, InterruptedException {
        try {
            this.writer.write(value.convertToTSRecord());
        }
        catch (WriteProcessException e) {
            throw new InterruptedException(String.format("Write tsfile record error %s", new Object[]{e}));
        }
    }

    public void close(TaskAttemptContext context) throws IOException {
        logger.info("Close the record writer, the task attempt id is {}", (Object)context.getTaskAttemptID());
        this.writer.close();
    }
}

