/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.hadoop.tsfile.record;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.Writable;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.StringContainer;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.BooleanDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.DoubleDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.FloatDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.IntDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.LongDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.StringDataPoint;

public class HDFSTSRecord
implements Writable {
    private long time;
    private String deviceId;
    private List<DataPoint> dataPointList = new ArrayList<DataPoint>();

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public List<DataPoint> getDataPointList() {
        return this.dataPointList;
    }

    public void setDataPointList(List<DataPoint> dataPointList) {
        this.dataPointList = dataPointList;
    }

    public HDFSTSRecord() {
    }

    public HDFSTSRecord(long timestamp, String deviceId) {
        this.time = timestamp;
        this.deviceId = deviceId;
    }

    public TSRecord convertToTSRecord() {
        TSRecord tsRecord = new TSRecord(this.time, this.deviceId);
        tsRecord.dataPointList = this.dataPointList;
        return tsRecord;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.time);
        out.writeInt(this.deviceId.getBytes(StandardCharsets.UTF_8).length);
        out.write(this.deviceId.getBytes(StandardCharsets.UTF_8));
        out.writeInt(this.dataPointList.size());
        block8: for (DataPoint dataPoint : this.dataPointList) {
            out.write(dataPoint.getType().serialize());
            out.writeInt(dataPoint.getMeasurementId().getBytes(StandardCharsets.UTF_8).length);
            out.write(dataPoint.getMeasurementId().getBytes(StandardCharsets.UTF_8));
            switch (dataPoint.getType()) {
                case BOOLEAN: {
                    out.writeBoolean((Boolean)dataPoint.getValue());
                    continue block8;
                }
                case INT32: {
                    out.writeInt((Integer)dataPoint.getValue());
                    continue block8;
                }
                case INT64: {
                    out.writeLong((Long)dataPoint.getValue());
                    continue block8;
                }
                case FLOAT: {
                    out.writeFloat(((Float)dataPoint.getValue()).floatValue());
                    continue block8;
                }
                case DOUBLE: {
                    out.writeDouble((Double)dataPoint.getValue());
                    continue block8;
                }
                case TEXT: {
                    out.writeInt(((Binary)dataPoint.getValue()).getLength());
                    out.write(((Binary)dataPoint.getValue()).getValues());
                    continue block8;
                }
            }
            throw new UnSupportedDataTypeException("The type isn't supported");
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.time = in.readLong();
        int lenOfDeviceId = in.readInt();
        byte[] deviceBytes = new byte[lenOfDeviceId];
        in.readFully(deviceBytes);
        int len = in.readInt();
        ArrayList<DataPoint> dataPoints = new ArrayList<DataPoint>(len);
        block8: for (int i = 0; i < len; ++i) {
            TSDataType dataType = TSDataType.deserialize((byte)in.readByte());
            int lenOfMeasurementId = in.readInt();
            byte[] c = new byte[lenOfMeasurementId];
            in.readFully(c);
            String measurementId = new String(c, StandardCharsets.UTF_8);
            switch (dataType) {
                case BOOLEAN: {
                    dataPoints.add((DataPoint)new BooleanDataPoint(measurementId, in.readBoolean()));
                    continue block8;
                }
                case INT32: {
                    dataPoints.add((DataPoint)new IntDataPoint(measurementId, in.readInt()));
                    continue block8;
                }
                case INT64: {
                    dataPoints.add((DataPoint)new LongDataPoint(measurementId, in.readLong()));
                    continue block8;
                }
                case FLOAT: {
                    dataPoints.add((DataPoint)new FloatDataPoint(measurementId, in.readFloat()));
                    continue block8;
                }
                case DOUBLE: {
                    dataPoints.add((DataPoint)new DoubleDataPoint(measurementId, in.readDouble()));
                    continue block8;
                }
                case TEXT: {
                    int stringLen = in.readInt();
                    byte[] b = new byte[stringLen];
                    in.readFully(b);
                    Binary binary = new Binary(b);
                    dataPoints.add((DataPoint)new StringDataPoint(measurementId, binary));
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException("The type isn't supported");
                }
            }
        }
        this.dataPointList = dataPoints;
    }

    public String toString() {
        StringContainer sc = new StringContainer(" ");
        sc.addTail(new Object[]{"{device id:", this.deviceId, "time:", this.time, ",data:["});
        for (DataPoint tuple : this.dataPointList) {
            sc.addTail(new Object[]{tuple});
        }
        sc.addTail(new String[]{"]}"});
        return sc.toString();
    }

    public HDFSTSRecord addTuple(DataPoint tuple) {
        this.dataPointList.add(tuple);
        return this;
    }
}

