/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.common.conf;

import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.fileSystem.FSType;

public class TSFileConfig
implements Serializable {
    public static final int RLE_MIN_REPEATED_NUM = 8;
    public static final int RLE_MAX_REPEATED_NUM = Short.MAX_VALUE;
    public static final int RLE_MAX_BIT_PACKED_NUM = 63;
    public static final int FLOAT_VALUE_LENGTH = 6;
    public static final int DOUBLE_VALUE_LENGTH = 7;
    public static final int VALUE_BITS_LENGTH_32BIT = 32;
    public static final int LEADING_ZERO_BITS_LENGTH_32BIT = 5;
    public static final int MEANINGFUL_XOR_BITS_LENGTH_32BIT = 5;
    public static final int VALUE_BITS_LENGTH_64BIT = 64;
    public static final int LEADING_ZERO_BITS_LENGTH_64BIT = 6;
    public static final int MEANINGFUL_XOR_BITS_LENGTH_64BIT = 6;
    public static final int GORILLA_ENCODING_ENDING_INTEGER = Integer.MIN_VALUE;
    public static final long GORILLA_ENCODING_ENDING_LONG = Long.MIN_VALUE;
    public static final float GORILLA_ENCODING_ENDING_FLOAT = Float.NaN;
    public static final double GORILLA_ENCODING_ENDING_DOUBLE = Double.NaN;
    public static final int BYTE_SIZE_PER_CHAR = 4;
    public static final String STRING_ENCODING = "UTF-8";
    public static final Charset STRING_CHARSET = Charset.forName("UTF-8");
    public static final String CONFIG_FILE_NAME = "iotdb-engine.properties";
    public static final String MAGIC_STRING = "TsFile";
    public static final String VERSION_NUMBER_V2 = "000002";
    public static final String VERSION_NUMBER_V1 = "000001";
    public static final byte VERSION_NUMBER = 3;
    public static final double MIN_BLOOM_FILTER_ERROR_RATE = 0.01;
    public static final double MAX_BLOOM_FILTER_ERROR_RATE = 0.1;
    public static final int ARRAY_CAPACITY_THRESHOLD = 1000;
    private int groupSizeInByte = 0x8000000;
    private int pageSizeInByte = 65536;
    private int maxNumberOfPointsInPage = 0x100000;
    private int maxDegreeOfIndexNode = 256;
    private String timeSeriesDataType = "INT64";
    private int maxStringLength = 128;
    private int floatPrecision = 2;
    private String timeEncoding = "TS_2DIFF";
    private String valueEncoder = "PLAIN";
    private int rleBitWidth = 8;
    private int deltaBlockSize = 128;
    private String freqType = "SINGLE_FREQ";
    private double plaMaxError = 100.0;
    private double sdtMaxError = 100.0;
    private double dftSatisfyRate = 0.1;
    private CompressionType compressor = CompressionType.SNAPPY;
    private int pageCheckSizeThreshold = 100;
    private String endian = "BIG_ENDIAN";
    private FSType TSFileStorageFs = FSType.LOCAL;
    private String coreSitePath = "/etc/hadoop/conf/core-site.xml";
    private String hdfsSitePath = "/etc/hadoop/conf/hdfs-site.xml";
    private String hdfsIp = "localhost";
    private String hdfsPort = "9000";
    private String dfsNameServices = "hdfsnamespace";
    private String dfsHaNamenodes = "nn1,nn2";
    private boolean dfsHaAutomaticFailoverEnabled = true;
    private String dfsClientFailoverProxyProvider = "org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider";
    private boolean useKerberos = false;
    private String kerberosKeytabFilePath = "/path";
    private String kerberosPrincipal = "principal";
    private double bloomFilterErrorRate = 0.05;
    private int batchSize = 1000;

    public int getGroupSizeInByte() {
        return this.groupSizeInByte;
    }

    public void setGroupSizeInByte(int groupSizeInByte) {
        this.groupSizeInByte = groupSizeInByte;
    }

    public int getPageSizeInByte() {
        return this.pageSizeInByte;
    }

    public void setPageSizeInByte(int pageSizeInByte) {
        this.pageSizeInByte = pageSizeInByte;
    }

    public int getMaxNumberOfPointsInPage() {
        return this.maxNumberOfPointsInPage;
    }

    public void setMaxNumberOfPointsInPage(int maxNumberOfPointsInPage) {
        this.maxNumberOfPointsInPage = maxNumberOfPointsInPage;
    }

    public int getMaxDegreeOfIndexNode() {
        return this.maxDegreeOfIndexNode;
    }

    public void setMaxDegreeOfIndexNode(int maxDegreeOfIndexNode) {
        this.maxDegreeOfIndexNode = maxDegreeOfIndexNode;
    }

    public String getTimeSeriesDataType() {
        return this.timeSeriesDataType;
    }

    public void setTimeSeriesDataType(String timeSeriesDataType) {
        this.timeSeriesDataType = timeSeriesDataType;
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public void setMaxStringLength(int maxStringLength) {
        this.maxStringLength = maxStringLength;
    }

    public int getFloatPrecision() {
        return this.floatPrecision;
    }

    public void setFloatPrecision(int floatPrecision) {
        this.floatPrecision = floatPrecision;
    }

    public String getTimeEncoder() {
        return this.timeEncoding;
    }

    public void setTimeEncoder(String timeEncoder) {
        this.timeEncoding = timeEncoder;
    }

    public String getValueEncoder() {
        return this.valueEncoder;
    }

    public void setValueEncoder(String valueEncoder) {
        this.valueEncoder = valueEncoder;
    }

    public int getRleBitWidth() {
        return this.rleBitWidth;
    }

    public void setRleBitWidth(int rleBitWidth) {
        this.rleBitWidth = rleBitWidth;
    }

    public int getDeltaBlockSize() {
        return this.deltaBlockSize;
    }

    public void setDeltaBlockSize(int deltaBlockSize) {
        this.deltaBlockSize = deltaBlockSize;
    }

    public String getFreqType() {
        return this.freqType;
    }

    public void setFreqType(String freqType) {
        this.freqType = freqType;
    }

    public double getPlaMaxError() {
        return this.plaMaxError;
    }

    public void setPlaMaxError(double plaMaxError) {
        this.plaMaxError = plaMaxError;
    }

    public double getSdtMaxError() {
        return this.sdtMaxError;
    }

    public void setSdtMaxError(double sdtMaxError) {
        this.sdtMaxError = sdtMaxError;
    }

    public double getDftSatisfyRate() {
        return this.dftSatisfyRate;
    }

    public void setDftSatisfyRate(double dftSatisfyRate) {
        this.dftSatisfyRate = dftSatisfyRate;
    }

    public CompressionType getCompressor() {
        return this.compressor;
    }

    public void setCompressor(String compressor) {
        this.compressor = CompressionType.valueOf(compressor);
    }

    public int getPageCheckSizeThreshold() {
        return this.pageCheckSizeThreshold;
    }

    public void setPageCheckSizeThreshold(int pageCheckSizeThreshold) {
        this.pageCheckSizeThreshold = pageCheckSizeThreshold;
    }

    public String getEndian() {
        return this.endian;
    }

    public void setEndian(String endian) {
        this.endian = endian;
    }

    public boolean isUseKerberos() {
        return this.useKerberos;
    }

    public void setUseKerberos(boolean useKerberos) {
        this.useKerberos = useKerberos;
    }

    public String getKerberosKeytabFilePath() {
        return this.kerberosKeytabFilePath;
    }

    public void setKerberosKeytabFilePath(String kerberosKeytabFilePath) {
        this.kerberosKeytabFilePath = kerberosKeytabFilePath;
    }

    public String getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    public void setKerberosPrincipal(String kerberosPrincipal) {
        this.kerberosPrincipal = kerberosPrincipal;
    }

    public double getBloomFilterErrorRate() {
        return this.bloomFilterErrorRate;
    }

    public void setBloomFilterErrorRate(double bloomFilterErrorRate) {
        this.bloomFilterErrorRate = bloomFilterErrorRate;
    }

    public FSType getTSFileStorageFs() {
        return this.TSFileStorageFs;
    }

    public void setTSFileStorageFs(FSType fileStorageFs) {
        this.TSFileStorageFs = fileStorageFs;
    }

    public String getCoreSitePath() {
        return this.coreSitePath;
    }

    public void setCoreSitePath(String coreSitePath) {
        this.coreSitePath = coreSitePath;
    }

    public String getHdfsSitePath() {
        return this.hdfsSitePath;
    }

    public void setHdfsSitePath(String hdfsSitePath) {
        this.hdfsSitePath = hdfsSitePath;
    }

    public String[] getHdfsIp() {
        return this.hdfsIp.split(",");
    }

    public void setHdfsIp(String[] hdfsIp) {
        this.hdfsIp = String.join((CharSequence)",", hdfsIp);
    }

    public String getHdfsPort() {
        return this.hdfsPort;
    }

    public void setHdfsPort(String hdfsPort) {
        this.hdfsPort = hdfsPort;
    }

    public String getDfsNameServices() {
        return this.dfsNameServices;
    }

    public void setDfsNameServices(String dfsNameServices) {
        this.dfsNameServices = dfsNameServices;
    }

    public String[] getDfsHaNamenodes() {
        return this.dfsHaNamenodes.split(",");
    }

    public void setDfsHaNamenodes(String[] dfsHaNamenodes) {
        this.dfsHaNamenodes = String.join((CharSequence)",", dfsHaNamenodes);
    }

    public boolean isDfsHaAutomaticFailoverEnabled() {
        return this.dfsHaAutomaticFailoverEnabled;
    }

    public void setDfsHaAutomaticFailoverEnabled(boolean dfsHaAutomaticFailoverEnabled) {
        this.dfsHaAutomaticFailoverEnabled = dfsHaAutomaticFailoverEnabled;
    }

    public String getDfsClientFailoverProxyProvider() {
        return this.dfsClientFailoverProxyProvider;
    }

    public void setDfsClientFailoverProxyProvider(String dfsClientFailoverProxyProvider) {
        this.dfsClientFailoverProxyProvider = dfsClientFailoverProxyProvider;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }
}

