/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter;

import java.util.Calendar;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.iotdb.tsfile.read.filter.GroupByFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class GroupByMonthFilter
extends GroupByFilter {
    private final boolean isSlidingStepByMonth;
    private final boolean isIntervalByMonth;
    private int slidingStepsInMo;
    private int intervalInMo;
    private Calendar calendar = Calendar.getInstance();
    private static final long MS_TO_MONTH = 2592000000L;
    private final long initialStartTime;

    public GroupByMonthFilter(long interval, long slidingStep, long startTime, long endTime, boolean isSlidingStepByMonth, boolean isIntervalByMonth, TimeZone timeZone) {
        super(interval, slidingStep, startTime, endTime);
        this.initialStartTime = startTime;
        this.calendar.setTimeZone(timeZone);
        this.calendar.setTimeInMillis(startTime);
        this.isIntervalByMonth = isIntervalByMonth;
        this.isSlidingStepByMonth = isSlidingStepByMonth;
        if (isIntervalByMonth) {
            this.intervalInMo = (int)(interval / 2592000000L);
        }
        if (isSlidingStepByMonth) {
            this.slidingStepsInMo = (int)(slidingStep / 2592000000L);
        }
        this.getNthTimeInterval(0L);
    }

    public GroupByMonthFilter(GroupByMonthFilter filter) {
        super(filter.interval, filter.slidingStep, filter.startTime, filter.endTime);
        this.isIntervalByMonth = filter.isIntervalByMonth;
        this.isSlidingStepByMonth = filter.isSlidingStepByMonth;
        this.intervalInMo = filter.intervalInMo;
        this.slidingStepsInMo = filter.slidingStepsInMo;
        this.initialStartTime = filter.initialStartTime;
        this.calendar = Calendar.getInstance();
        this.calendar.setTimeZone(filter.calendar.getTimeZone());
        this.calendar.setTimeInMillis(filter.calendar.getTimeInMillis());
    }

    @Override
    public boolean satisfy(long time, Object value) {
        if (time < this.initialStartTime || time >= this.endTime) {
            return false;
        }
        if (time >= this.startTime && time < this.startTime + this.slidingStep) {
            return time - this.startTime < this.interval;
        }
        long count = this.getTimePointPosition(time);
        this.getNthTimeInterval(count);
        return time - this.startTime < this.interval;
    }

    @Override
    public boolean satisfyStartEndTime(long startTime, long endTime) {
        if (this.satisfyCurrentInterval(startTime, endTime)) {
            return true;
        }
        long count = this.getTimePointPosition(startTime);
        this.getNthTimeInterval(count);
        if (this.satisfyCurrentInterval(startTime, endTime)) {
            return true;
        }
        this.getNthTimeInterval(count + 1L);
        return this.satisfyCurrentInterval(startTime, endTime);
    }

    @Override
    public Filter copy() {
        return new GroupByMonthFilter(this);
    }

    private boolean satisfyCurrentInterval(long startTime, long endTime) {
        if (endTime < this.startTime || startTime >= this.endTime) {
            return false;
        }
        return startTime - this.startTime < this.interval;
    }

    @Override
    public boolean containStartEndTime(long startTime, long endTime) {
        if (this.isContainedByCurrentInterval(startTime, endTime)) {
            return true;
        }
        long count = this.getTimePointPosition(startTime);
        this.getNthTimeInterval(count);
        return this.isContainedByCurrentInterval(startTime, endTime);
    }

    private boolean isContainedByCurrentInterval(long startTime, long endTime) {
        if (startTime < this.startTime || endTime > this.endTime) {
            return false;
        }
        return startTime - this.startTime < this.interval && endTime - this.startTime < this.interval;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof GroupByMonthFilter)) {
            return false;
        }
        GroupByMonthFilter other = (GroupByMonthFilter)obj;
        return this.interval == other.interval && this.slidingStep == other.slidingStep && this.startTime == other.startTime && this.endTime == other.endTime && this.isSlidingStepByMonth == other.isSlidingStepByMonth && this.isIntervalByMonth == other.isIntervalByMonth;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.interval, this.slidingStep, this.startTime, this.endTime, this.isSlidingStepByMonth, this.isIntervalByMonth);
    }

    private long getTimePointPosition(long time) {
        long count;
        if (this.isSlidingStepByMonth) {
            count = (time - this.initialStartTime) / ((long)(this.slidingStepsInMo * 31) * 86400000L);
            this.calendar.setTimeInMillis(this.initialStartTime);
            this.calendar.add(2, (int)count * this.slidingStepsInMo);
            while (this.calendar.getTimeInMillis() < time) {
                this.calendar.setTimeInMillis(this.initialStartTime);
                this.calendar.add(2, (int)(count + 1L) * this.slidingStepsInMo);
                if (this.calendar.getTimeInMillis() <= time) {
                    ++count;
                    continue;
                }
                break;
            }
        } else {
            count = (time - this.initialStartTime) / this.slidingStep;
        }
        return count;
    }

    private void getNthTimeInterval(long n) {
        if (this.isSlidingStepByMonth) {
            this.calendar.setTimeInMillis(this.initialStartTime);
            this.calendar.add(2, (int)((long)this.slidingStepsInMo * n));
        } else {
            this.calendar.setTimeInMillis(this.initialStartTime + this.slidingStep * n);
        }
        this.startTime = this.calendar.getTimeInMillis();
        if (this.isIntervalByMonth) {
            if (this.isSlidingStepByMonth) {
                this.calendar.setTimeInMillis(this.initialStartTime);
                this.calendar.add(2, (int)((long)this.slidingStepsInMo * n) + this.intervalInMo);
            } else {
                this.calendar.add(2, this.intervalInMo);
            }
            this.interval = this.calendar.getTimeInMillis() - this.startTime;
        }
        if (this.isSlidingStepByMonth) {
            this.calendar.setTimeInMillis(this.initialStartTime);
            this.calendar.add(2, (int)((long)this.slidingStepsInMo * (n + 1L)));
            this.slidingStep = this.calendar.getTimeInMillis() - this.startTime;
        }
    }
}

