/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.client.sync;

import java.io.Closeable;
import org.apache.iotdb.cluster.client.sync.SyncClientFactory;
import org.apache.iotdb.cluster.client.sync.SyncClientPool;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.iotdb.cluster.rpc.thrift.TSMetaService;
import org.apache.iotdb.cluster.server.RaftServer;
import org.apache.iotdb.rpc.RpcTransportFactory;
import org.apache.iotdb.rpc.TConfigurationConst;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class SyncMetaClient
extends TSMetaService.Client
implements Closeable {
    Node node;
    SyncClientPool pool;

    SyncMetaClient(TProtocol prot) {
        super(prot);
    }

    public SyncMetaClient(TProtocolFactory protocolFactory, Node node, SyncClientPool pool) throws TTransportException {
        super(protocolFactory.getProtocol(RpcTransportFactory.INSTANCE.getTransport((TTransport)new TSocket(TConfigurationConst.defaultTConfiguration, node.getInternalIp(), node.getMetaPort(), RaftServer.getConnectionTimeoutInMS()))));
        this.node = node;
        this.pool = pool;
        this.getInputProtocol().getTransport().open();
    }

    public void putBack() {
        if (this.pool != null) {
            this.pool.putClient(this.node, (RaftService.Client)this);
        } else {
            this.getInputProtocol().getTransport().close();
        }
    }

    @Override
    public void close() {
        this.putBack();
    }

    public Node getNode() {
        return this.node;
    }

    public String toString() {
        return "SyncMetaClient{ node=" + this.node + ", pool=" + this.pool + "}";
    }

    public static class FactorySync
    implements SyncClientFactory {
        private TProtocolFactory protocolFactory;

        public FactorySync(TProtocolFactory protocolFactory) {
            this.protocolFactory = protocolFactory;
        }

        public SyncMetaClient getSyncClient(Node node, SyncClientPool pool) throws TTransportException {
            return new SyncMetaClient(this.protocolFactory, node, pool);
        }
    }
}

