/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log.manage;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.cluster.log.LogApplier;
import org.apache.iotdb.cluster.log.Snapshot;
import org.apache.iotdb.cluster.log.manage.RaftLogManager;
import org.apache.iotdb.cluster.log.manage.serializable.SyncLogDequeSerializer;
import org.apache.iotdb.cluster.log.snapshot.PartitionedSnapshot;
import org.apache.iotdb.cluster.log.snapshot.SnapshotFactory;
import org.apache.iotdb.cluster.partition.PartitionTable;
import org.apache.iotdb.cluster.partition.slot.SlotPartitionTable;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.member.DataGroupMember;
import org.apache.iotdb.db.metadata.mnode.MNode;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.tsfile.write.schema.TimeseriesSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PartitionedSnapshotLogManager<T extends Snapshot>
extends RaftLogManager {
    private static final Logger logger = LoggerFactory.getLogger(PartitionedSnapshotLogManager.class);
    Map<Integer, T> slotSnapshots = new HashMap<Integer, T>();
    private SnapshotFactory<T> factory;
    Map<Integer, Collection<TimeseriesSchema>> slotTimeseries = new HashMap<Integer, Collection<TimeseriesSchema>>();
    long snapshotLastLogIndex;
    long snapshotLastLogTerm;
    PartitionTable partitionTable;
    Node thisNode;
    DataGroupMember dataGroupMember;

    protected PartitionedSnapshotLogManager(LogApplier logApplier, PartitionTable partitionTable, Node header, Node thisNode, SnapshotFactory<T> factory, DataGroupMember dataGroupMember) {
        super(new SyncLogDequeSerializer(header.nodeIdentifier), logApplier, header.toString());
        this.partitionTable = partitionTable;
        this.factory = factory;
        this.thisNode = thisNode;
        this.dataGroupMember = dataGroupMember;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Snapshot getSnapshot(long minIndex) {
        Map<Integer, T> map = this.slotSnapshots;
        synchronized (map) {
            PartitionedSnapshot<Snapshot> partitionedSnapshot = new PartitionedSnapshot<Snapshot>(this.factory);
            for (Map.Entry<Integer, T> entry : this.slotSnapshots.entrySet()) {
                partitionedSnapshot.putSnapshot(entry.getKey(), (Snapshot)entry.getValue());
            }
            partitionedSnapshot.setLastLogIndex(this.snapshotLastLogIndex);
            partitionedSnapshot.setLastLogTerm(this.snapshotLastLogTerm);
            partitionedSnapshot.truncateBefore(minIndex);
            return partitionedSnapshot;
        }
    }

    void collectTimeseriesSchemas() {
        this.slotTimeseries.clear();
        List allSgNodes = IoTDB.metaManager.getAllStorageGroupNodes();
        List<Integer> slots = null;
        if (this.dataGroupMember.getMetaGroupMember() != null) {
            slots = ((SlotPartitionTable)this.dataGroupMember.getMetaGroupMember().getPartitionTable()).getNodeSlots(this.dataGroupMember.getHeader());
        }
        for (MNode sgNode : allSgNodes) {
            String storageGroupName = sgNode.getFullPath();
            int slot = SlotPartitionTable.getSlotStrategy().calculateSlotByTime(storageGroupName, 0L, ((SlotPartitionTable)this.partitionTable).getTotalSlotNumbers());
            boolean slotExistsInPartition = slots == null || slots.contains(slot);
            if (!slotExistsInPartition) continue;
            Collection schemas = this.slotTimeseries.computeIfAbsent(slot, s -> new HashSet());
            IoTDB.metaManager.collectTimeseriesSchema(sgNode, schemas);
            logger.debug("{}: {} timeseries are snapshot in slot {}", new Object[]{this.getName(), schemas.size(), slot});
        }
    }
}

