/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.cluster.query.ClusterDataQueryExecutor;
import org.apache.iotdb.cluster.query.ClusterUDTFQueryExecutor;
import org.apache.iotdb.cluster.query.aggregate.ClusterAggregateExecutor;
import org.apache.iotdb.cluster.query.fill.ClusterFillExecutor;
import org.apache.iotdb.cluster.query.groupby.ClusterGroupByNoVFilterDataSet;
import org.apache.iotdb.cluster.query.groupby.ClusterGroupByVFilterDataSet;
import org.apache.iotdb.cluster.query.last.ClusterLastQueryExecutor;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimePlan;
import org.apache.iotdb.db.qp.physical.crud.LastQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.groupby.GroupByWithValueFilterDataSet;
import org.apache.iotdb.db.query.dataset.groupby.GroupByWithoutValueFilterDataSet;
import org.apache.iotdb.db.query.executor.AggregationExecutor;
import org.apache.iotdb.db.query.executor.FillQueryExecutor;
import org.apache.iotdb.db.query.executor.LastQueryExecutor;
import org.apache.iotdb.db.query.executor.QueryRouter;
import org.apache.iotdb.db.query.executor.RawDataQueryExecutor;
import org.apache.iotdb.db.query.executor.fill.IFill;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.expression.ExpressionType;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.util.ExpressionOptimizer;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;

public class ClusterQueryRouter
extends QueryRouter {
    private MetaGroupMember metaGroupMember;

    ClusterQueryRouter(MetaGroupMember metaGroupMember) {
        this.metaGroupMember = metaGroupMember;
    }

    protected FillQueryExecutor getFillExecutor(List<PartialPath> fillPaths, List<TSDataType> dataTypes, long queryTime, Map<TSDataType, IFill> fillType) {
        return new ClusterFillExecutor(fillPaths, dataTypes, queryTime, fillType, this.metaGroupMember);
    }

    protected GroupByWithoutValueFilterDataSet getGroupByWithoutValueFilterDataSet(QueryContext context, GroupByTimePlan plan) throws StorageEngineException, QueryProcessException {
        return new ClusterGroupByNoVFilterDataSet(context, plan, this.metaGroupMember);
    }

    protected GroupByWithValueFilterDataSet getGroupByWithValueFilterDataSet(QueryContext context, GroupByTimePlan plan) throws StorageEngineException, QueryProcessException {
        return new ClusterGroupByVFilterDataSet(context, plan, this.metaGroupMember);
    }

    protected AggregationExecutor getAggregationExecutor(AggregationPlan aggregationPlan) {
        return new ClusterAggregateExecutor(aggregationPlan, this.metaGroupMember);
    }

    protected RawDataQueryExecutor getRawDataQueryExecutor(RawDataQueryPlan queryPlan) {
        return new ClusterDataQueryExecutor(queryPlan, this.metaGroupMember);
    }

    protected LastQueryExecutor getLastQueryExecutor(LastQueryPlan lastQueryPlan) {
        return new ClusterLastQueryExecutor(lastQueryPlan, this.metaGroupMember);
    }

    public QueryDataSet udtfQuery(UDTFPlan udtfPlan, QueryContext context) throws StorageEngineException, QueryProcessException, IOException, InterruptedException {
        IExpression optimizedExpression;
        IExpression expression = udtfPlan.getExpression();
        try {
            optimizedExpression = expression == null ? null : ExpressionOptimizer.getInstance().optimize(expression, new ArrayList(udtfPlan.getDeduplicatedPaths()));
        }
        catch (QueryFilterOptimizationException e) {
            throw new StorageEngineException(e.getMessage());
        }
        udtfPlan.setExpression(optimizedExpression);
        boolean withValueFilter = optimizedExpression != null && optimizedExpression.getType() != ExpressionType.GLOBAL_TIME;
        ClusterUDTFQueryExecutor clusterUDTFQueryExecutor = new ClusterUDTFQueryExecutor(udtfPlan, this.metaGroupMember);
        if (udtfPlan.isAlignByTime()) {
            return withValueFilter ? clusterUDTFQueryExecutor.executeWithValueFilterAlignByTime(context) : clusterUDTFQueryExecutor.executeWithoutValueFilterAlignByTime(context);
        }
        return withValueFilter ? clusterUDTFQueryExecutor.executeWithValueFilterNonAlign(context) : clusterUDTFQueryExecutor.executeWithoutValueFilterNonAlign(context);
    }
}

