/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.cluster.query.ClusterDataQueryExecutor;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.UDTFAlignByTimeDataSet;
import org.apache.iotdb.db.query.dataset.UDTFNonAlignDataSet;
import org.apache.iotdb.db.query.reader.series.ManagedSeriesReader;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.read.query.executor.ExecutorWithTimeGenerator;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGenerator;

public class ClusterUDTFQueryExecutor
extends ClusterDataQueryExecutor {
    protected final UDTFPlan udtfPlan;
    protected final MetaGroupMember metaGroupMember;

    public ClusterUDTFQueryExecutor(UDTFPlan udtfPlan, MetaGroupMember metaGroupMember) {
        super((RawDataQueryPlan)udtfPlan, metaGroupMember);
        this.udtfPlan = udtfPlan;
        this.metaGroupMember = metaGroupMember;
    }

    public QueryDataSet executeWithoutValueFilterAlignByTime(QueryContext context) throws StorageEngineException, QueryProcessException, IOException, InterruptedException {
        List<ManagedSeriesReader> readersOfSelectedSeries = this.initManagedSeriesReader(context);
        return new UDTFAlignByTimeDataSet(context, this.udtfPlan, this.udtfPlan.getDeduplicatedPaths(), this.udtfPlan.getDeduplicatedDataTypes(), readersOfSelectedSeries);
    }

    public QueryDataSet executeWithValueFilterAlignByTime(QueryContext context) throws StorageEngineException, QueryProcessException, IOException {
        TimeGenerator timestampGenerator = this.getTimeGenerator(context, (RawDataQueryPlan)this.udtfPlan);
        List cached = ExecutorWithTimeGenerator.markFilterdPaths((IExpression)this.udtfPlan.getExpression(), new ArrayList(this.udtfPlan.getDeduplicatedPaths()), (boolean)timestampGenerator.hasOrNode());
        List readersOfSelectedSeries = this.initSeriesReaderByTimestamp(context, (RawDataQueryPlan)this.udtfPlan, cached);
        return new UDTFAlignByTimeDataSet(context, this.udtfPlan, this.udtfPlan.getDeduplicatedPaths(), this.udtfPlan.getDeduplicatedDataTypes(), timestampGenerator, readersOfSelectedSeries, cached);
    }

    public QueryDataSet executeWithoutValueFilterNonAlign(QueryContext context) throws QueryProcessException, StorageEngineException, IOException, InterruptedException {
        List<ManagedSeriesReader> readersOfSelectedSeries = this.initManagedSeriesReader(context);
        return new UDTFNonAlignDataSet(context, this.udtfPlan, this.udtfPlan.getDeduplicatedPaths(), this.udtfPlan.getDeduplicatedDataTypes(), readersOfSelectedSeries);
    }

    public QueryDataSet executeWithValueFilterNonAlign(QueryContext context) throws QueryProcessException, StorageEngineException, IOException {
        TimeGenerator timestampGenerator = this.getTimeGenerator(context, (RawDataQueryPlan)this.udtfPlan);
        List cached = ExecutorWithTimeGenerator.markFilterdPaths((IExpression)this.udtfPlan.getExpression(), new ArrayList(this.udtfPlan.getDeduplicatedPaths()), (boolean)timestampGenerator.hasOrNode());
        List readersOfSelectedSeries = this.initSeriesReaderByTimestamp(context, (RawDataQueryPlan)this.udtfPlan, cached);
        return new UDTFNonAlignDataSet(context, this.udtfPlan, this.udtfPlan.getDeduplicatedPaths(), this.udtfPlan.getDeduplicatedDataTypes(), timestampGenerator, readersOfSelectedSeries, cached);
    }
}

