/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.cluster.client.async.AsyncDataClient;
import org.apache.iotdb.cluster.client.sync.SyncClientAdaptor;
import org.apache.iotdb.cluster.client.sync.SyncDataClient;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.log.snapshot.PullSnapshotTaskDescriptor;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.member.DataGroupMember;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullSnapshotHintService {
    private static final Logger logger = LoggerFactory.getLogger(PullSnapshotHintService.class);
    private DataGroupMember member;
    private ScheduledExecutorService service;
    private ConcurrentLinkedDeque<PullSnapshotHint> hints;

    public PullSnapshotHintService(DataGroupMember member) {
        this.member = member;
        this.hints = new ConcurrentLinkedDeque();
    }

    public void start() {
        this.service = Executors.newScheduledThreadPool(1);
        this.service.scheduleAtFixedRate(this::sendHints, 0L, 1L, TimeUnit.MINUTES);
    }

    public void stop() {
        if (this.service == null) {
            return;
        }
        this.service.shutdown();
        try {
            this.service.awaitTermination(3L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("{}: PullSnapshotHintService exiting interrupted", (Object)this.member.getName());
        }
        this.service = null;
    }

    public void registerHint(PullSnapshotTaskDescriptor descriptor) {
        PullSnapshotHint hint = new PullSnapshotHint();
        hint.receivers = new ArrayList<Node>(descriptor.getPreviousHolders());
        hint.header = descriptor.getPreviousHolders().getHeader();
        hint.slots = descriptor.getSlots();
        this.hints.add(hint);
    }

    private void sendHints() {
        Iterator<PullSnapshotHint> iterator = this.hints.iterator();
        while (iterator.hasNext()) {
            PullSnapshotHint hint = iterator.next();
            Iterator iter = hint.receivers.iterator();
            while (iter.hasNext()) {
                Node receiver = (Node)iter.next();
                try {
                    boolean result = this.sendHint(receiver, hint);
                    if (!result) continue;
                    iter.remove();
                }
                catch (TException e) {
                    logger.warn("Cannot send pull snapshot hint to {}", (Object)receiver);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.warn("Sending hint to {} interrupted", (Object)receiver);
                }
            }
            if (!hint.receivers.isEmpty()) continue;
            iterator.remove();
        }
    }

    private boolean sendHint(Node receiver, PullSnapshotHint hint) throws TException, InterruptedException {
        boolean result = ClusterDescriptor.getInstance().getConfig().isUseAsyncServer() ? this.sendHintsAsync(receiver, hint) : this.sendHintSync(receiver, hint);
        return result;
    }

    private boolean sendHintsAsync(Node receiver, PullSnapshotHint hint) throws TException, InterruptedException {
        AsyncDataClient asyncDataClient = (AsyncDataClient)this.member.getAsyncClient(receiver);
        return SyncClientAdaptor.onSnapshotApplied(asyncDataClient, hint.header, hint.slots);
    }

    private boolean sendHintSync(Node receiver, PullSnapshotHint hint) throws TException {
        try (SyncDataClient syncDataClient = (SyncDataClient)this.member.getSyncClient(receiver);){
            if (syncDataClient == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = syncDataClient.onSnapshotApplied(hint.header, hint.slots);
            return bl;
        }
    }

    private static class PullSnapshotHint {
        private List<Node> receivers;
        private Node header;
        private List<Integer> slots;

        private PullSnapshotHint() {
        }
    }
}

