/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.handlers.caller;

import java.net.ConnectException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.log.Log;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.member.RaftMember;
import org.apache.iotdb.cluster.server.monitor.Peer;
import org.apache.iotdb.cluster.server.monitor.Timer;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendNodeEntryHandler
implements AsyncMethodCallback<Long> {
    private static final Logger logger = LoggerFactory.getLogger(AppendNodeEntryHandler.class);
    private RaftMember member;
    private AtomicLong receiverTerm;
    private Log log;
    private AtomicInteger voteCounter;
    private AtomicBoolean leaderShipStale;
    private Node receiver;
    private Peer peer;
    private int failedDecreasingCounter;
    private long sendStart = Long.MIN_VALUE;

    public AppendNodeEntryHandler() {
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            this.sendStart = System.nanoTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete(Long response) {
        Timer.Statistic.RAFT_SENDER_SEND_LOG_ASYNC.calOperationCostTimeFromStart(this.sendStart);
        if (this.voteCounter.get() == Integer.MAX_VALUE) {
            return;
        }
        logger.debug("{}: Append response {} from {}", new Object[]{this.member.getName(), response, this.receiver});
        if (this.leaderShipStale.get()) {
            return;
        }
        long resp = response;
        AtomicInteger atomicInteger = this.voteCounter;
        synchronized (atomicInteger) {
            if (resp == -1L) {
                int remaining = this.voteCounter.decrementAndGet();
                logger.debug("{}: Received an agreement from {} for {}, remaining votes to succeed: {}", new Object[]{this.member.getName(), this.receiver, this.log, remaining});
                if (remaining == 0) {
                    logger.debug("{}: Log [{}] {} is accepted by the quorum", new Object[]{this.member.getName(), this.log.getCurrLogIndex(), this.log});
                    this.voteCounter.notifyAll();
                }
                this.peer.setMatchIndex(Math.max(this.log.getCurrLogIndex(), this.peer.getMatchIndex()));
            } else if (resp > 0L) {
                long prevReceiverTerm = this.receiverTerm.get();
                logger.debug("{}: Received a rejection from {} because term is stale: {}/{}", new Object[]{this.member.getName(), this.receiver, prevReceiverTerm, resp});
                if (resp > prevReceiverTerm) {
                    this.receiverTerm.set(resp);
                }
                this.leaderShipStale.set(true);
                this.voteCounter.notifyAll();
            } else {
                logger.debug("{}: The log {} is rejected by {} because: {}", new Object[]{this.member.getName(), this.log, this.receiver, resp});
                this.onFail();
            }
        }
    }

    public void onError(Exception exception) {
        if (exception instanceof ConnectException) {
            logger.warn("{}: Cannot append log {}: cannot connect to {}: {}", new Object[]{this.member.getName(), this.log, this.receiver, exception.getMessage()});
        } else {
            logger.warn("{}: Cannot append log {} to {}", new Object[]{this.member.getName(), this.log, this.receiver, exception});
        }
        this.onFail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFail() {
        AtomicInteger atomicInteger = this.voteCounter;
        synchronized (atomicInteger) {
            --this.failedDecreasingCounter;
            if (this.failedDecreasingCounter <= 0) {
                this.voteCounter.set(Integer.MAX_VALUE);
                this.voteCounter.notifyAll();
            }
        }
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setMember(RaftMember member) {
        this.member = member;
    }

    public void setVoteCounter(AtomicInteger voteCounter) {
        this.voteCounter = voteCounter;
        this.failedDecreasingCounter = ClusterDescriptor.getInstance().getConfig().getReplicationNum() - voteCounter.get();
    }

    public void setLeaderShipStale(AtomicBoolean leaderShipStale) {
        this.leaderShipStale = leaderShipStale;
    }

    public void setPeer(Peer peer) {
        this.peer = peer;
    }

    public void setReceiver(Node follower) {
        this.receiver = follower;
    }

    public void setReceiverTerm(AtomicLong receiverTerm) {
        this.receiverTerm = receiverTerm;
    }
}

