/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.service;

import org.apache.iotdb.cluster.exception.AddSelfException;
import org.apache.iotdb.cluster.exception.LeaderUnknownException;
import org.apache.iotdb.cluster.exception.LogExecutionException;
import org.apache.iotdb.cluster.exception.PartitionTableUnavailableException;
import org.apache.iotdb.cluster.rpc.thrift.AddNodeResponse;
import org.apache.iotdb.cluster.rpc.thrift.AppendEntryRequest;
import org.apache.iotdb.cluster.rpc.thrift.CheckStatusResponse;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.SendSnapshotRequest;
import org.apache.iotdb.cluster.rpc.thrift.StartUpStatus;
import org.apache.iotdb.cluster.rpc.thrift.TNodeStatus;
import org.apache.iotdb.cluster.rpc.thrift.TSMetaService;
import org.apache.iotdb.cluster.server.NodeCharacter;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.cluster.server.service.BaseAsyncService;
import org.apache.iotdb.cluster.utils.ClusterUtils;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaAsyncService
extends BaseAsyncService
implements TSMetaService.AsyncIface {
    private static final Logger logger = LoggerFactory.getLogger(MetaAsyncService.class);
    private MetaGroupMember metaGroupMember;

    public MetaAsyncService(MetaGroupMember metaGroupMember) {
        super(metaGroupMember);
        this.metaGroupMember = metaGroupMember;
    }

    public void appendEntry(AppendEntryRequest request, AsyncMethodCallback resultHandler) {
        if (this.metaGroupMember.getPartitionTable() == null) {
            logger.debug("This node is blind to the cluster and cannot accept logs");
            resultHandler.onComplete((Object)-4L);
            return;
        }
        super.appendEntry(request, (AsyncMethodCallback<Long>)resultHandler);
    }

    public void addNode(Node node, StartUpStatus startUpStatus, AsyncMethodCallback<AddNodeResponse> resultHandler) {
        AddNodeResponse addNodeResponse = null;
        try {
            addNodeResponse = this.metaGroupMember.addNode(node, startUpStatus);
        }
        catch (AddSelfException | LogExecutionException e) {
            resultHandler.onError(e);
        }
        if (addNodeResponse != null) {
            resultHandler.onComplete((Object)addNodeResponse);
            return;
        }
        if (this.member.getCharacter() == NodeCharacter.FOLLOWER && this.member.getLeader() != null) {
            logger.info("Forward the join request of {} to leader {}", (Object)node, (Object)this.member.getLeader());
            if (this.forwardAddNode(node, startUpStatus, resultHandler)) {
                return;
            }
        }
        resultHandler.onError((Exception)new LeaderUnknownException(this.member.getAllNodes()));
    }

    public void sendSnapshot(SendSnapshotRequest request, AsyncMethodCallback<Void> resultHandler) {
        try {
            this.metaGroupMember.receiveSnapshot(request);
        }
        catch (Exception e) {
            resultHandler.onError(e);
            return;
        }
        resultHandler.onComplete(null);
    }

    public void checkStatus(StartUpStatus startUpStatus, AsyncMethodCallback<CheckStatusResponse> resultHandler) {
        CheckStatusResponse response = ClusterUtils.checkStatus(startUpStatus, this.metaGroupMember.getNewStartUpStatus());
        resultHandler.onComplete((Object)response);
    }

    private boolean forwardAddNode(Node node, StartUpStatus startUpStatus, AsyncMethodCallback<AddNodeResponse> resultHandler) {
        TSMetaService.AsyncClient client = (TSMetaService.AsyncClient)this.metaGroupMember.getAsyncClient(this.metaGroupMember.getLeader());
        if (client != null) {
            try {
                client.addNode(node, startUpStatus, resultHandler);
                return true;
            }
            catch (TException e) {
                logger.warn("Cannot connect to node {}", (Object)node, (Object)e);
            }
        }
        return false;
    }

    public void queryNodeStatus(AsyncMethodCallback<TNodeStatus> resultHandler) {
        resultHandler.onComplete((Object)new TNodeStatus());
    }

    public void checkAlive(AsyncMethodCallback<Node> resultHandler) {
        resultHandler.onComplete((Object)this.metaGroupMember.getThisNode());
    }

    public void removeNode(Node node, AsyncMethodCallback<Long> resultHandler) {
        long result = Long.MIN_VALUE;
        try {
            result = this.metaGroupMember.removeNode(node);
        }
        catch (LogExecutionException | PartitionTableUnavailableException e) {
            resultHandler.onError(e);
        }
        if (result != Long.MIN_VALUE) {
            resultHandler.onComplete((Object)result);
            return;
        }
        if (this.metaGroupMember.getCharacter() == NodeCharacter.FOLLOWER && this.metaGroupMember.getLeader() != null) {
            logger.info("Forward the node removal request of {} to leader {}", (Object)node, (Object)this.metaGroupMember.getLeader());
            if (this.forwardRemoveNode(node, resultHandler)) {
                return;
            }
        }
        resultHandler.onError((Exception)new LeaderUnknownException(this.metaGroupMember.getAllNodes()));
    }

    private boolean forwardRemoveNode(Node node, AsyncMethodCallback<Long> resultHandler) {
        TSMetaService.AsyncClient client = (TSMetaService.AsyncClient)this.metaGroupMember.getAsyncClient(this.metaGroupMember.getLeader());
        if (client != null) {
            try {
                client.removeNode(node, resultHandler);
                return true;
            }
            catch (TException e) {
                logger.warn("Cannot connect to node {}", (Object)node, (Object)e);
            }
        }
        return false;
    }

    public void exile(AsyncMethodCallback<Void> resultHandler) {
        this.metaGroupMember.applyRemoveNode(this.metaGroupMember.getThisNode());
        resultHandler.onComplete(null);
    }

    public void handshake(Node sender, AsyncMethodCallback<Void> resultHandler) {
        this.metaGroupMember.handleHandshake(sender);
        resultHandler.onComplete(null);
    }
}

