/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.engine.compaction.StorageGroupCompactionTask;
import org.apache.iotdb.db.engine.merge.manage.MergeManager;
import org.apache.iotdb.db.engine.merge.manage.MergeResource;
import org.apache.iotdb.db.engine.merge.selector.IMergeFileSelector;
import org.apache.iotdb.db.engine.merge.selector.MaxFileMergeFileSelector;
import org.apache.iotdb.db.engine.merge.selector.MaxSeriesMergeFileSelector;
import org.apache.iotdb.db.engine.merge.selector.MergeFileStrategy;
import org.apache.iotdb.db.engine.merge.task.MergeTask;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.MergeException;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TsFileManagement {
    private static final Logger logger = LoggerFactory.getLogger(TsFileManagement.class);
    protected String storageGroupName;
    protected String storageGroupDir;
    private final ReadWriteLock compactionMergeLock = new ReentrantReadWriteLock();
    public volatile boolean isUnseqMerging = false;
    public volatile boolean isSeqMerging = false;
    public volatile boolean recovered = false;
    public ModificationFile mergingModification;
    protected boolean isMergeExecutedInCurrentTask = false;
    protected boolean isForceFullMerge = IoTDBDescriptor.getInstance().getConfig().isForceFullMerge();
    private final int maxOpenFileNumInEachUnseqCompaction = IoTDBDescriptor.getInstance().getConfig().getMaxSelectUnseqFileNumInEachUnseqCompaction();

    public TsFileManagement(String storageGroupName, String storageGroupDir) {
        this.storageGroupName = storageGroupName;
        this.storageGroupDir = storageGroupDir;
    }

    public void setForceFullMerge(boolean forceFullMerge) {
        this.isForceFullMerge = forceFullMerge;
    }

    @Deprecated
    public abstract List<TsFileResource> getTsFileList(boolean var1);

    public abstract List<TsFileResource> getTsFileListByTimePartition(boolean var1, long var2);

    public abstract Iterator<TsFileResource> getIterator(boolean var1);

    public abstract void remove(TsFileResource var1, boolean var2);

    public abstract void removeAll(List<TsFileResource> var1, boolean var2);

    public abstract void add(TsFileResource var1, boolean var2) throws IOException;

    public abstract void addRecover(TsFileResource var1, boolean var2);

    public abstract void addAll(List<TsFileResource> var1, boolean var2) throws IOException;

    public abstract boolean contains(TsFileResource var1, boolean var2);

    public abstract void clear();

    public abstract boolean isEmpty(boolean var1);

    public abstract int size(boolean var1);

    public abstract void recover();

    public abstract void forkCurrentFileList(long var1) throws IOException;

    public void readLock() {
        this.compactionMergeLock.readLock().lock();
    }

    public void readUnLock() {
        this.compactionMergeLock.readLock().unlock();
    }

    public void writeLock() {
        this.compactionMergeLock.writeLock().lock();
    }

    public void writeUnlock() {
        this.compactionMergeLock.writeLock().unlock();
    }

    public boolean tryWriteLock() {
        return this.compactionMergeLock.writeLock().tryLock();
    }

    protected abstract void merge(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean merge(boolean fullMerge, List<TsFileResource> seqMergeList, List<TsFileResource> unSeqMergeList, long dataTTL) {
        while (this.isSeqMerging) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                logger.error("{} [Compaction] shutdown", (Object)this.storageGroupName, (Object)e);
                Thread.currentThread().interrupt();
                return false;
            }
        }
        this.isUnseqMerging = true;
        this.writeLock();
        try {
            List[] mergeFiles;
            IMergeFileSelector fileSelector;
            MergeResource mergeResource;
            block21: {
                if (seqMergeList.isEmpty()) {
                    logger.info("{} no seq files to be merged", (Object)this.storageGroupName);
                    this.isUnseqMerging = false;
                    boolean e = false;
                    return e;
                }
                if (unSeqMergeList.isEmpty()) {
                    logger.info("{} no unseq files to be merged", (Object)this.storageGroupName);
                    this.isUnseqMerging = false;
                    boolean e = false;
                    return e;
                }
                if (unSeqMergeList.size() > this.maxOpenFileNumInEachUnseqCompaction) {
                    logger.info("{} too much unseq files to be merged, reduce it to {}", (Object)this.storageGroupName, (Object)this.maxOpenFileNumInEachUnseqCompaction);
                    unSeqMergeList = unSeqMergeList.subList(0, this.maxOpenFileNumInEachUnseqCompaction);
                }
                long budget = IoTDBDescriptor.getInstance().getConfig().getMergeMemoryBudget();
                long timeLowerBound = System.currentTimeMillis() - dataTTL;
                mergeResource = new MergeResource(seqMergeList, unSeqMergeList, timeLowerBound);
                fileSelector = this.getMergeFileSelector(budget, mergeResource);
                mergeFiles = fileSelector.select();
                if (mergeFiles.length != 0) break block21;
                logger.info("{} cannot select merge candidates under the budget {}", (Object)this.storageGroupName, (Object)budget);
                this.isUnseqMerging = false;
                boolean bl = false;
                return bl;
            }
            try {
                mergeResource.clear();
                String taskName = this.storageGroupName + "-" + System.currentTimeMillis();
                mergeResource.setCacheDeviceMeta(true);
                for (TsFileResource tsFileResource : mergeResource.getSeqFiles()) {
                    tsFileResource.setMerging(true);
                }
                for (TsFileResource tsFileResource : mergeResource.getUnseqFiles()) {
                    tsFileResource.setMerging(true);
                }
                long mergeStartTime = System.currentTimeMillis();
                MergeTask mergeTask = new MergeTask(mergeResource, this.storageGroupDir, this::mergeEndAction, taskName, fullMerge, fileSelector.getConcurrentMergeNum(), this.storageGroupName);
                this.mergingModification = new ModificationFile(this.storageGroupDir + File.separator + "merge.mods");
                MergeManager.getINSTANCE().submitMainTask(mergeTask);
                if (logger.isInfoEnabled()) {
                    logger.info("{} submits a merge task {}, merging {} seqFiles, {} unseqFiles", new Object[]{this.storageGroupName, taskName, mergeFiles[0].size(), mergeFiles[1].size()});
                }
            }
            catch (IOException | MergeException e) {
                logger.error("{} cannot select file for merge", (Object)this.storageGroupName, (Object)e);
                boolean bl = false;
                this.writeUnlock();
                return bl;
            }
        }
        finally {
            this.writeUnlock();
        }
        while (this.isUnseqMerging) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                logger.error("{} [Compaction] shutdown", (Object)this.storageGroupName, (Object)e);
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return true;
    }

    private IMergeFileSelector getMergeFileSelector(long budget, MergeResource resource) {
        MergeFileStrategy strategy = IoTDBDescriptor.getInstance().getConfig().getMergeFileStrategy();
        switch (strategy) {
            case MAX_FILE_NUM: {
                return new MaxFileMergeFileSelector(resource, budget);
            }
            case MAX_SERIES_NUM: {
                return new MaxSeriesMergeFileSelector(resource, budget);
            }
        }
        throw new UnsupportedOperationException("Unknown MergeFileStrategy " + (Object)((Object)strategy));
    }

    private void doubleWriteLock(TsFileResource seqFile) {
        while (true) {
            boolean fileLockGot = seqFile.tryWriteLock();
            boolean compactionLockGot = this.tryWriteLock();
            if (fileLockGot && compactionLockGot) break;
            if (compactionLockGot) {
                this.writeUnlock();
            }
            if (!fileLockGot) continue;
            seqFile.writeUnlock();
        }
    }

    private void doubleWriteUnlock(TsFileResource seqFile) {
        this.writeUnlock();
        seqFile.writeUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUnseqFiles(List<TsFileResource> unseqFiles) {
        this.writeLock();
        try {
            this.removeAll(unseqFiles, false);
            if (IoTDBDescriptor.getInstance().getConfig().isMetaDataCacheEnable()) {
                ChunkCache.getInstance().clear();
                TimeSeriesMetadataCache.getInstance().clear();
            }
        }
        finally {
            this.writeUnlock();
        }
        for (TsFileResource unseqFile : unseqFiles) {
            unseqFile.writeLock();
            try {
                unseqFile.remove();
            }
            finally {
                unseqFile.writeUnlock();
            }
        }
    }

    private void updateMergeModification(TsFileResource seqFile) {
        try {
            seqFile.removeModFile();
            if (this.mergingModification != null) {
                for (Modification modification : this.mergingModification.getModifications()) {
                    modification.setFileOffset(Long.MAX_VALUE);
                    seqFile.getModFile().write(modification);
                }
                try {
                    seqFile.getModFile().close();
                }
                catch (IOException e) {
                    logger.error("Cannot close the ModificationFile {}", (Object)seqFile.getModFile().getFilePath(), (Object)e);
                }
            }
        }
        catch (IOException e) {
            logger.error("{} cannot clean the ModificationFile of {} after merge", new Object[]{this.storageGroupName, seqFile.getTsFile(), e});
        }
    }

    private void removeMergingModification() {
        try {
            if (this.mergingModification != null) {
                this.mergingModification.remove();
                this.mergingModification = null;
            }
        }
        catch (IOException e) {
            logger.error("{} cannot remove merging modification ", (Object)this.storageGroupName, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeEndAction(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles, File mergeLog) {
        logger.info("{} a merge task is ending...", (Object)this.storageGroupName);
        if (Thread.currentThread().isInterrupted() || unseqFiles.isEmpty()) {
            this.isUnseqMerging = false;
            logger.info("{} a merge task abnormally ends", (Object)this.storageGroupName);
            return;
        }
        this.removeUnseqFiles(unseqFiles);
        for (int i = 0; i < seqFiles.size(); ++i) {
            TsFileResource seqFile = seqFiles.get(i);
            this.doubleWriteLock(seqFile);
            try {
                boolean deletionSuccess;
                File mergedFile = FSFactoryProducer.getFSFactory().getFile(seqFile.getTsFilePath() + ".merge");
                if (mergedFile.exists() && !(deletionSuccess = mergedFile.delete())) {
                    logger.warn("fail to delete {}", (Object)mergedFile);
                }
                this.updateMergeModification(seqFile);
                continue;
            }
            finally {
                this.doubleWriteUnlock(seqFile);
            }
        }
        try {
            this.removeMergingModification();
            this.isUnseqMerging = false;
            Files.delete(mergeLog.toPath());
        }
        catch (IOException e) {
            logger.error("{} a merge task ends but cannot delete log {}", (Object)this.storageGroupName, (Object)mergeLog.toPath());
        }
        logger.info("{} a merge task ends", (Object)this.storageGroupName);
    }

    public static int compareFileName(File o1, File o2) {
        long ver2;
        String[] items1 = o1.getName().replace(".tsfile", "").split("-");
        String[] items2 = o2.getName().replace(".tsfile", "").split("-");
        long ver1 = Long.parseLong(items1[0]);
        int cmp = Long.compare(ver1, ver2 = Long.parseLong(items2[0]));
        if (cmp == 0) {
            int cmpVersion = Long.compare(Long.parseLong(items1[1]), Long.parseLong(items2[1]));
            if (cmpVersion == 0) {
                return Long.compare(Long.parseLong(items1[2]), Long.parseLong(items2[2]));
            }
            return cmpVersion;
        }
        return cmp;
    }

    public class CompactionRecoverTask
    extends StorageGroupCompactionTask {
        private StorageGroupProcessor.CloseCompactionMergeCallBack closeCompactionMergeCallBack;

        public CompactionRecoverTask(StorageGroupProcessor.CloseCompactionMergeCallBack closeCompactionMergeCallBack) {
            super(TsFileManagement.this.storageGroupName);
            this.closeCompactionMergeCallBack = closeCompactionMergeCallBack;
        }

        @Override
        public Void call() {
            TsFileManagement.this.recover();
            this.closeCompactionMergeCallBack.call(false, 0L);
            return null;
        }
    }

    public class CompactionMergeTask {
        private StorageGroupProcessor.CloseCompactionMergeCallBack closeCompactionMergeCallBack;
        private long timePartitionId;

        public CompactionMergeTask(StorageGroupProcessor.CloseCompactionMergeCallBack closeCompactionMergeCallBack, long timePartitionId) {
            this.closeCompactionMergeCallBack = closeCompactionMergeCallBack;
            this.timePartitionId = timePartitionId;
        }

        public Void call() {
            TsFileManagement.this.merge(this.timePartitionId);
            this.closeCompactionMergeCallBack.call(TsFileManagement.this.isMergeExecutedInCurrentTask, this.timePartitionId);
            return null;
        }
    }
}

