/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.flush.pool;

import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.concurrent.ThreadName;
import org.apache.iotdb.db.engine.flush.pool.AbstractPoolManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlushSubTaskPoolManager
extends AbstractPoolManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlushSubTaskPoolManager.class);

    private FlushSubTaskPoolManager() {
        this.pool = IoTDBThreadPoolFactory.newCachedThreadPool(ThreadName.FLUSH_SUB_TASK_SERVICE.getName());
    }

    public static FlushSubTaskPoolManager getInstance() {
        return InstanceHolder.instance;
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public String getName() {
        return "flush sub task";
    }

    @Override
    public void start() {
        if (this.pool == null) {
            this.pool = IoTDBThreadPoolFactory.newCachedThreadPool(ThreadName.FLUSH_SUB_TASK_SERVICE.getName());
        }
        LOGGER.info("Flush sub task manager started.");
    }

    @Override
    public void stop() {
        super.stop();
        LOGGER.info("Flush sub task manager stopped");
    }

    private static class InstanceHolder {
        private static FlushSubTaskPoolManager instance = new FlushSubTaskPoolManager();

        private InstanceHolder() {
        }
    }
}

