/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.MetaUtils;
import org.apache.iotdb.tsfile.read.common.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartialPath
extends Path
implements Comparable<Path> {
    private static final Logger logger = LoggerFactory.getLogger(PartialPath.class);
    private String[] nodes;
    private String measurementAlias = "";
    private String tsAlias = "";

    public PartialPath(String path) throws IllegalPathException {
        this.nodes = MetaUtils.splitPathToDetachedPath(path);
        this.fullPath = path;
    }

    public PartialPath(String device, String measurement) throws IllegalPathException {
        this.fullPath = device + "." + measurement;
        this.nodes = MetaUtils.splitPathToDetachedPath(this.fullPath);
    }

    public PartialPath(String[] partialNodes) {
        this.nodes = partialNodes;
    }

    public PartialPath(String path, boolean needSplit) {
        super(path, needSplit);
    }

    public PartialPath concatPath(PartialPath partialPath) {
        int len = this.nodes.length;
        String[] newNodes = Arrays.copyOf(this.nodes, this.nodes.length + partialPath.nodes.length);
        System.arraycopy(partialPath.nodes, 0, newNodes, len, partialPath.nodes.length);
        return new PartialPath(newNodes);
    }

    void concatPath(String[] otherNodes) {
        int len = this.nodes.length;
        this.nodes = Arrays.copyOf(this.nodes, this.nodes.length + otherNodes.length);
        System.arraycopy(otherNodes, 0, this.nodes, len, otherNodes.length);
        this.fullPath = String.join((CharSequence)".", this.nodes);
    }

    public PartialPath concatNode(String node) {
        String[] newPathNodes = Arrays.copyOf(this.nodes, this.nodes.length + 1);
        newPathNodes[newPathNodes.length - 1] = node;
        return new PartialPath(newPathNodes);
    }

    public String[] getNodes() {
        return this.nodes;
    }

    public int getNodeLength() {
        return this.nodes.length;
    }

    public String getTailNode() {
        if (this.nodes.length <= 0) {
            return "";
        }
        return this.nodes[this.nodes.length - 1];
    }

    public PartialPath alterPrefixPath(PartialPath prefixPath) {
        String[] newNodes = Arrays.copyOf(this.nodes, Math.max(this.nodes.length, prefixPath.getNodeLength()));
        System.arraycopy(prefixPath.getNodes(), 0, newNodes, 0, prefixPath.getNodeLength());
        return new PartialPath(newNodes);
    }

    public boolean matchFullPath(PartialPath rPath) {
        String[] rNodes = rPath.getNodes();
        if (rNodes.length < this.nodes.length) {
            return false;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i].equals("*") || this.nodes[i].equals(rNodes[i])) continue;
            return false;
        }
        return true;
    }

    public String getFullPath() {
        if (this.fullPath != null) {
            return this.fullPath;
        }
        StringBuilder s = new StringBuilder(this.nodes[0]);
        for (int i = 1; i < this.nodes.length; ++i) {
            s.append(".").append(this.nodes[i]);
        }
        this.fullPath = s.toString();
        return this.fullPath;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PartialPath)) {
            return false;
        }
        String[] otherNodes = ((PartialPath)obj).getNodes();
        if (this.nodes.length != otherNodes.length) {
            return false;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i].equals(otherNodes[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(String obj) {
        return this.getFullPath().equals(obj);
    }

    public int hashCode() {
        return this.getFullPath().hashCode();
    }

    public String getMeasurement() {
        return this.nodes[this.nodes.length - 1];
    }

    public String getFirstNode() {
        return this.nodes[0];
    }

    public String getDevice() {
        if (this.device != null) {
            return this.device;
        }
        if (this.nodes.length == 1) {
            return "";
        }
        StringBuilder s = new StringBuilder(this.nodes[0]);
        for (int i = 1; i < this.nodes.length - 1; ++i) {
            s.append(".");
            s.append(this.nodes[i]);
        }
        this.device = s.toString();
        return this.device;
    }

    public String getMeasurementAlias() {
        return this.measurementAlias;
    }

    public void setMeasurementAlias(String measurementAlias) {
        this.measurementAlias = measurementAlias;
    }

    public boolean isMeasurementAliasExists() {
        return this.measurementAlias != null && !this.measurementAlias.isEmpty();
    }

    public String getTsAlias() {
        return this.tsAlias;
    }

    public void setTsAlias(String tsAlias) {
        this.tsAlias = tsAlias;
    }

    public boolean isTsAliasExists() {
        return this.tsAlias != null && !this.tsAlias.isEmpty();
    }

    public String getFullPathWithAlias() {
        return this.getDevice() + '.' + this.measurementAlias;
    }

    @Override
    public int compareTo(Path path) {
        PartialPath partialPath = (PartialPath)path;
        return this.getFullPath().compareTo(partialPath.getFullPath());
    }

    public boolean startsWith(String[] otherNodes) {
        for (int i = 0; i < otherNodes.length; ++i) {
            if (this.nodes[i].equals(otherNodes[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getFullPath();
    }

    public PartialPath getDevicePath() {
        return new PartialPath(Arrays.copyOf(this.nodes, this.nodes.length - 1));
    }

    public Path toTSFilePath() {
        return new Path(this.getDevice(), this.getMeasurement());
    }

    public static List<String> toStringList(List<PartialPath> pathList) {
        ArrayList<String> ret = new ArrayList<String>();
        for (PartialPath path : pathList) {
            ret.add(path.getFullPath());
        }
        return ret;
    }

    public static List<PartialPath> fromStringList(List<String> pathList) {
        if (pathList == null || pathList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PartialPath> ret = new ArrayList<PartialPath>();
        for (String s : pathList) {
            try {
                ret.add(new PartialPath(s));
            }
            catch (IllegalPathException e) {
                logger.warn("Encountered an illegal path {}", (Object)s);
            }
        }
        return ret;
    }
}

